/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.geoserver.wps.CompositeComparator;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.util.logging.Logging;

public class MemoryProcessStatusStore
implements ProcessStatusStore {
    static final Logger LOGGER = Logging.getLogger(MemoryProcessStatusStore.class);
    Map<String, ExecutionStatus> statuses = new ConcurrentHashMap<String, ExecutionStatus>();

    @Override
    public void save(ExecutionStatus status) {
        boolean succeded = false;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Saving status " + status);
        }
        while (!succeded) {
            ExecutionStatus oldStatus = this.statuses.get(status.getExecutionId());
            ExecutionStatus newStatus = new ExecutionStatus(status);
            if (oldStatus != null) {
                ProcessState previousPhase = oldStatus.getPhase();
                ProcessState currPhase = status.getPhase();
                if (!currPhase.isValidSuccessor(previousPhase)) {
                    throw new WPSException("Cannot switch process status from " + previousPhase + " to " + currPhase);
                }
                ExecutionStatus prevInMap = this.statuses.put(status.getExecutionId(), newStatus);
                succeded = prevInMap == oldStatus;
                continue;
            }
            ExecutionStatus previous = this.statuses.put(status.getExecutionId(), newStatus);
            succeded = previous == null;
        }
    }

    @Override
    public int remove(Filter filter) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Removing statuses matching " + filter);
        }
        int count = 0;
        for (ExecutionStatus status : this.statuses.values()) {
            if (!filter.evaluate((Object)status)) continue;
            ++count;
            this.statuses.remove(status.getExecutionId());
        }
        return count;
    }

    @Override
    public List<ExecutionStatus> list(Query query) {
        Integer startIndex;
        List<ExecutionStatus> result = new ArrayList<ExecutionStatus>();
        Filter filter = query.getFilter();
        for (ExecutionStatus status : this.statuses.values()) {
            if (!filter.evaluate((Object)status)) continue;
            result.add(status);
        }
        SortBy[] sorts = query.getSortBy();
        if (sorts != null) {
            ArrayList comparators = new ArrayList();
            for (SortBy sort : sorts) {
                if (sort == SortBy.NATURAL_ORDER) {
                    comparators.add(new BeanComparator("creationTime"));
                    continue;
                }
                if (sort == SortBy.REVERSE_ORDER) {
                    comparators.add(Collections.reverseOrder(new BeanComparator("creationTime")));
                    continue;
                }
                String property = sort.getPropertyName().getPropertyName();
                if ("node".equalsIgnoreCase(property)) {
                    property = "nodeId";
                } else if ("user".equalsIgnoreCase(property)) {
                    property = "userName";
                } else if ("task".equalsIgnoreCase(property)) {
                    property = "task";
                }
                Object comparator = new BeanComparator(property);
                if (sort.getSortOrder() == SortOrder.DESCENDING) {
                    comparator = Collections.reverseOrder(comparator);
                }
                comparators.add(comparator);
            }
            if (comparators.size() > 1) {
                CompositeComparator comparator = new CompositeComparator(comparators);
                Collections.sort(result, comparator);
            } else if (comparators.size() == 1) {
                Collections.sort(result, (Comparator)comparators.get(0));
            }
        }
        if ((startIndex = query.getStartIndex()) != null && startIndex > 0) {
            if (startIndex > result.size()) {
                result.clear();
            } else {
                result = result.subList(startIndex, result.size());
            }
        }
        if (result.size() > query.getMaxFeatures()) {
            result = result.subList(0, query.getMaxFeatures());
        }
        return result;
    }

    @Override
    public ExecutionStatus get(String executionId) {
        return this.statuses.get(executionId);
    }

    @Override
    public ExecutionStatus remove(String executionId) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Removing status for execution id: " + executionId);
        }
        return this.statuses.remove(executionId);
    }

    @Override
    public boolean supportsPredicate() {
        return true;
    }

    @Override
    public boolean supportsPaging() {
        return false;
    }
}

