/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.List;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecurityUtils;
import org.geoserver.wps.GetExecutionsTransformer;
import org.geoserver.wps.GetExecutionsType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.kvp.GetExecutionsKvpFilterBuilder;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.data.Query;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class Executions {
    public static final String NO_SUCH_PARAMETER_CODE = "NoSuchParameter";
    public static final String NO_SUCH_PROCESS_CODE = "NoSuchProcess";
    public static final String INTERNAL_SERVER_ERROR_CODE = "InternalServerError";
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    static final Logger LOGGER = Logging.getLogger(Executions.class);
    private static final int MAX_EXECUTIONS_PER_PAGE = 10;
    private GeoServer gs;
    private ProcessStatusTracker statusTracker;
    private WPSResourceManager resources;
    private ApplicationContext ctx;

    public Executions(GeoServer gs, ProcessStatusTracker statusTracker, WPSResourceManager resources, ApplicationContext ctx) {
        this.gs = gs;
        this.statusTracker = statusTracker;
        this.resources = resources;
        this.ctx = ctx;
    }

    public Object run(GetExecutionsType request) {
        List<ExecutionStatus> statuses;
        Integer startIndex;
        String sortAttribute;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Object principal = auth != null && auth.getPrincipal() != null ? auth.getPrincipal() : null;
        boolean isAdmin = this.getSecurityManager().checkAuthenticationForAdminRole(auth);
        if (!isAdmin) {
            if (principal == null) {
                throw new WPSException(NO_SUCH_PROCESS_CODE, "No Process Execution available.");
            }
            if (request.owner != null && !request.owner.isEmpty() && !SecurityUtils.getUsername((Object)principal).equalsIgnoreCase(request.owner)) {
                throw new WPSException(NO_SUCH_PARAMETER_CODE, "Invalid parameter 'owner' specified.");
            }
        }
        GetExecutionsKvpFilterBuilder builder = new GetExecutionsKvpFilterBuilder(ff);
        if (request.owner != null && !request.owner.isEmpty()) {
            builder.appendUserNameFilter(request.owner);
        } else if (!isAdmin) {
            builder.appendUserNameFilter(SecurityUtils.getUsername((Object)principal));
        }
        if (request.identifier != null && !request.identifier.isEmpty()) {
            builder.appendProcessNameFilter(request.identifier);
        }
        if (request.status != null && !request.status.isEmpty()) {
            builder.appendStatusFilter(request.status);
        }
        Query queryFilter = new Query("GetExecutions", builder.getFilter());
        int total = this.statusTracker.getStore().list(queryFilter).size();
        if (request.orderBy != null && !request.orderBy.isEmpty() && (sortAttribute = this.translateAttributeName(request.orderBy)) != null && !sortAttribute.isEmpty()) {
            SortBy[] sortBy = new SortBy[]{ff.sort(sortAttribute, SortOrder.DESCENDING)};
            queryFilter.setSortBy(sortBy);
        }
        if ((startIndex = request.getStartIndex()) != null) {
            queryFilter.setStartIndex(startIndex);
        } else if (total > 10) {
            startIndex = 0;
        }
        Integer maxFeatures = request.getMaxFeatures();
        if (maxFeatures == null && total > 10) {
            maxFeatures = 10;
        }
        if (maxFeatures != null) {
            queryFilter.setMaxFeatures(maxFeatures.intValue());
        }
        if ((statuses = this.statusTracker.getStore().list(queryFilter)) == null) {
            throw new WPSException(NO_SUCH_PROCESS_CODE, "No Process Execution available.");
        }
        GetExecutionsTransformer executionsTransformer = new GetExecutionsTransformer((WPSInfo)this.gs.getService(WPSInfo.class), this.resources, this.ctx, request, total, startIndex, maxFeatures);
        if (!statuses.isEmpty()) {
            for (ExecutionStatus status : statuses) {
                executionsTransformer.append(status);
            }
            return executionsTransformer;
        }
        throw new WPSException(NO_SUCH_PROCESS_CODE, "No Process Execution available.");
    }

    private String translateAttributeName(String orderBy) {
        switch (orderBy.toLowerCase()) {
            case "owner": {
                return "userName";
            }
            case "identifier": {
                return "processName";
            }
            case "jobid": {
                return "executionId";
            }
            case "status": {
                return "phase";
            }
        }
        return null;
    }

    private GeoServerSecurityManager getSecurityManager() {
        return (GeoServerSecurityManager)this.ctx.getBean(GeoServerSecurityManager.class);
    }
}

