/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.security.CatalogMode;
import org.geoserver.wps.security.AbstractWPSAccessTest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WPSAccessChallangeTest
extends AbstractWPSAccessTest {
    @Test
    public void testNotAuthenticatedCapabilitiesPermission() throws Exception {
        this.setRequestAuth(null, null);
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Process[ows:Identifier = 'JTS:buffer'])", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Process[ows:Identifier = 'JTS:intersects'])", (Document)d);
    }

    @Test
    public void testAuthenticatedCapabilitiesPermission() throws Exception {
        this.setRequestAuth("test", "test");
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Process[ows:Identifier = 'JTS:buffer'])", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wps:Process[ows:Identifier = 'JTS:intersects'])", (Document)d);
    }

    @Test
    public void testNotAuthenticatedDescribeProcessPermission() throws Exception {
        this.setRequestAuth(null, null);
        MockHttpServletResponse response = this.getAsServletResponse("wps?service=wps&request=describeprocess&identifier=JTS:buffer");
        Assert.assertEquals((long)response.getStatus(), (long)401L);
    }

    @Test
    public void testAuthenticatedDescribeProcessPermission() throws Exception {
        this.setRequestAuth("test", "test");
        Document d = this.getAsDOM("wps?service=wps&request=describeprocess&identifier=JTS:buffer");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ProcessDescription[ows:Identifier = 'JTS:buffer'])", (Document)d);
    }

    @Test
    public void testNotAuthenticatedExecutePermission() throws Exception {
        this.setRequestAuth(null, null);
        MockHttpServletResponse response = this.postAsServletResponse("wps", "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml; subtype=gml/2.1.2\"><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>");
        Assert.assertEquals((long)response.getStatus(), (long)401L);
    }

    @Test
    public void testAuthenticatedExecutePermission() throws Exception {
        this.setRequestAuth("test", "test");
        Document d = this.postAsDOM("wps", "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>JTS:buffer</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>distance</ows:Identifier><wps:Data><wps:LiteralData>1</wps:LiteralData></wps:Data></wps:Input><wps:Input><ows:Identifier>geom</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml; subtype=gml/2.1.2\"><gml:Polygon xmlns:gml='http://www.opengis.net/gml'><gml:exterior><gml:LinearRing><gml:coordinates>1 1 2 1 2 2 1 2 1 1</gml:coordinates></gml:LinearRing></gml:exterior></gml:Polygon></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>");
        this.checkValidationErrors(d);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:ProcessOutputs/wps:Output/wps:Data/wps:ComplexData/gml:Polygon", (Document)d);
    }

    @Override
    protected CatalogMode getMode() {
        return CatalogMode.CHALLENGE;
    }
}

