/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.resource.DefaultProcessArtifactsStore;
import org.geoserver.wps.resource.WPSFileResource;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class WPSResourceManagerTest
extends WPSTestSupport {
    WPSResourceManager resourceMgr;
    GeoServerResourceLoader resourceLoader;
    ProcessStatusTracker tracker;
    private static final File WPS_RESOURCE_DIR = new File("target/gs_datadir/tmp/wps");

    @Before
    public void setUpInternal() throws Exception {
        this.resourceLoader = this.getResourceLoader();
        this.resourceMgr = new WPSResourceManager(this.resourceLoader);
        this.resourceMgr.setApplicationContext((ApplicationContext)applicationContext);
        if (WPS_RESOURCE_DIR.exists()) {
            FileUtils.deleteDirectory((File)WPS_RESOURCE_DIR);
        }
        WPS_RESOURCE_DIR.mkdirs();
        FileSystemResourceStore resourceStore = new FileSystemResourceStore(WPS_RESOURCE_DIR);
        DefaultProcessArtifactsStore artifactsStore = (DefaultProcessArtifactsStore)this.resourceMgr.getArtifactsStore();
        artifactsStore.setResourceStore((ResourceStore)resourceStore);
        this.tracker = new ProcessStatusTracker();
        this.tracker.setApplicationContext(null);
    }

    @After
    public void cleanUp() throws Exception {
        if (WPS_RESOURCE_DIR.exists()) {
            FileUtils.deleteDirectory((File)WPS_RESOURCE_DIR);
        }
    }

    @Test
    public void testAddResourceNoExecutionId() throws Exception {
        File f = File.createTempFile("dummy", "dummy", new File("target"));
        this.resourceMgr.addResource((WPSResource)new WPSFileResource(f));
    }

    @Test
    public void testCleanupResource() throws Exception {
        String executionId = this.resourceMgr.getExecutionId(Boolean.valueOf(true));
        Resource result = this.resourceMgr.getOutputResource(executionId, "test.txt");
        File file = result.file();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write("dummy".getBytes());
        }
        Resource temp = this.resourceMgr.getTemporaryResource("tmp");
        File tempFile = temp.file();
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            fos.write("temptemptemp".getBytes());
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)tempFile.exists());
        File processDir = new File(WPS_RESOURCE_DIR, executionId);
        Assert.assertTrue((boolean)processDir.exists());
        Assert.assertTrue((boolean)processDir.isDirectory());
        Assert.assertEquals((long)2L, (long)processDir.listFiles().length);
        Thread.sleep(2L);
        this.resourceMgr.cleanExpiredResources(System.currentTimeMillis(), this.tracker);
        Assert.assertFalse((boolean)processDir.exists());
    }

    @Test
    public void testGetExternalOutputFileDisabled() throws Exception {
        this.resourceMgr.setExternalOutputDirectory(null);
        this.checkOutputFileException("foo", null, WPSException.class, "Writing to external output files is disabled");
        this.resourceMgr.setExternalOutputDirectory("");
        this.checkOutputFileException("foo", null, WPSException.class, "Writing to external output files is disabled");
        this.resourceMgr.setExternalOutputDirectory("    ");
        this.checkOutputFileException("foo", null, WPSException.class, "Writing to external output files is disabled");
    }

    @Test
    public void testGetExternalOutputFileEnabled() throws Exception {
        this.resourceMgr.setExternalOutputDirectory("file:test");
        this.checkOutputFileException("foo/../../", "bar", IllegalArgumentException.class, "Output file contains invalid '..' in path");
        this.checkOutputFileException("foo", "../../bar", IllegalArgumentException.class, "Output file contains invalid '..' in path");
        String path1 = new File(this.resourceLoader.getBaseDirectory(), "foo").getAbsolutePath();
        this.checkOutputFileException(path1, "bar", WPSException.class, "Output file is not in the allowed directory");
        File expected = new File(this.resourceLoader.getBaseDirectory(), "test/foo/bar").getAbsoluteFile();
        Assert.assertEquals((Object)expected, (Object)this.resourceMgr.getExternalOutputFile(expected.getPath(), null));
        String path2 = new File(this.resourceLoader.getBaseDirectory(), "test/foo").getAbsolutePath();
        Assert.assertEquals((Object)expected, (Object)this.resourceMgr.getExternalOutputFile(path2, "bar"));
        Assert.assertEquals((Object)expected, (Object)this.resourceMgr.getExternalOutputFile("foo/bar", null));
        Assert.assertEquals((Object)expected, (Object)this.resourceMgr.getExternalOutputFile("foo", "bar"));
    }

    private void checkOutputFileException(String path, String file, Class<? extends Exception> clazz, String message) {
        Exception exception = (Exception)Assert.assertThrows(clazz, () -> this.resourceMgr.getExternalOutputFile(path, file));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }
}

