/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.process;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.AbstractProcessFilterTest;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.process.vector.VectorProcessFactory;
import org.junit.After;
import org.junit.Before;

public class WPSConfigProcessFilterTest
extends AbstractProcessFilterTest {
    @Before
    public void setUpInternal() throws Exception {
        GeoServer gs = this.getGeoServer();
        WPSInfo wps = (WPSInfo)gs.getService(WPSInfo.class);
        NameImpl bufferName = new NameImpl("JTS", "buffer");
        ProcessFactory jts = Processors.createProcessFactory((Name)bufferName);
        ProcessGroupInfoImpl jtsGroup = new ProcessGroupInfoImpl();
        jtsGroup.setFactoryClass(jts.getClass());
        jtsGroup.setEnabled(true);
        ArrayList jtsNames = new ArrayList(jts.getNames());
        jtsNames.remove(bufferName);
        for (Name jtsName : jtsNames) {
            ProcessInfoImpl pai = new ProcessInfoImpl();
            pai.setName(jtsName);
            pai.setEnabled(Boolean.valueOf(false));
            jtsGroup.getFilteredProcesses().add(pai);
        }
        List pgs = wps.getProcessGroups();
        pgs.clear();
        pgs.add(jtsGroup);
        ProcessGroupInfoImpl gsGroup = new ProcessGroupInfoImpl();
        gsGroup.setFactoryClass(VectorProcessFactory.class);
        gsGroup.setEnabled(false);
        pgs.add(gsGroup);
        gs.save((ServiceInfo)wps);
    }

    @After
    public void cleanup() {
        GeoServer gs = this.getGeoServer();
        WPSInfo wps = (WPSInfo)gs.getService(WPSInfo.class);
        wps.getProcessGroups().clear();
        gs.save((ServiceInfo)wps);
    }
}

