/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geoserver.util.ZipTestUtil;
import org.geoserver.wps.ppio.ShapeZipPPIO;
import org.geoserver.wps.resource.ShapefileResource;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.data.store.ContentFeatureCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShapeZipPPIOTest {
    ShapefileResource resource;
    WPSResourceManager resources;
    ShapeZipPPIO ppio;

    @Before
    public void prepare() {
        this.resources = (WPSResourceManager)Mockito.mock(WPSResourceManager.class);
        this.ppio = new ShapeZipPPIO(this.resources, null, null, null);
    }

    @After
    public void cleanup() throws Exception {
        if (this.resource != null) {
            this.resource.delete();
        }
    }

    @Test
    public void testDecodeValid() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("empty-shapefile.zip");){
            ((WPSResourceManager)Mockito.doAnswer(inv -> {
                this.resource = (ShapefileResource)inv.getArgument(0, ShapefileResource.class);
                return null;
            }).when((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(ShapefileResource.class));
            Object result = this.ppio.decode(is);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(ContentFeatureCollection.class));
            ((WPSResourceManager)Mockito.verify((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(ShapefileResource.class));
        }
    }

    @Test
    public void testDecodeNoShapefiles() throws Exception {
        try (InputStream input = this.getClass().getResourceAsStream("invalid.zip");){
            IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> this.ppio.decode(input));
            Assert.assertEquals((Object)"Could not find any file with .shp extension in the zip file", (Object)exception.getMessage());
            ((WPSResourceManager)Mockito.verify((Object)this.resources, (VerificationMode)Mockito.never())).addResource((WPSResource)ArgumentMatchers.any());
        }
    }

    @Test
    public void testDecodeBadEntryName() throws Exception {
        try (ByteArrayInputStream input = ZipTestUtil.getZipSlipInput();){
            IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> this.ppio.decode(input));
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Entry is outside of the target directory"));
            ((WPSResourceManager)Mockito.verify((Object)this.resources, (VerificationMode)Mockito.never())).addResource((WPSResource)ArgumentMatchers.any());
        }
    }
}

