/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.easymock.EasyMock;
import org.geoserver.wps.ppio.RawDataPPIO;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.resource.WPSResourceManager;
import org.junit.Assert;
import org.junit.Test;

public class RawDataPPIOTest {
    @Test
    public void testInputStreamClosed() throws Exception {
        try (TestInputStream is = new TestInputStream();
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            RawDataPPIO ppio = this.buildRawDataPPIOWithMockManager();
            RawData rawData = this.mockRawDataWithInputStream(is);
            ppio.encode((Object)rawData, (OutputStream)os);
            Assert.assertTrue((boolean)is.isClosed());
        }
    }

    private RawDataPPIO buildRawDataPPIOWithMockManager() {
        WPSResourceManager resourceManager = (WPSResourceManager)EasyMock.createMock(WPSResourceManager.class);
        EasyMock.replay((Object[])new Object[]{resourceManager});
        return new RawDataPPIO(resourceManager);
    }

    private RawData mockRawDataWithInputStream(TestInputStream is) throws IOException {
        RawData rawData = (RawData)EasyMock.createMock(RawData.class);
        EasyMock.expect((Object)rawData.getInputStream()).andReturn((Object)is);
        EasyMock.replay((Object[])new Object[]{rawData});
        return rawData;
    }

    private class TestInputStream
    extends ByteArrayInputStream {
        private boolean isClosed;

        public TestInputStream() {
            super("Test data".getBytes());
            this.isClosed = false;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.isClosed = true;
        }
    }
}

