/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.ppio.GeoTiffPPIO;
import org.geoserver.wps.resource.GridCoverageReaderResource;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.process.raster.CropCoverage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.Node;

public class GeotiffPPIOTest {
    File geotiff = new File("./target/test.tiff");
    File target = new File("./target/target.tiff");
    GeoTiffReader reader;
    GridCoverage2D coverage;
    GridCoverageReaderResource resource;
    WPSResourceManager resources;
    GeoTiffPPIO ppio;

    @Before
    public void prepareGeoTiff() throws IOException {
        try (InputStream is = SystemTestData.class.getResourceAsStream("tazbm.tiff");){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)this.geotiff);
        }
        this.reader = new GeoTiffReader((Object)this.geotiff);
        this.resources = (WPSResourceManager)Mockito.mock(WPSResourceManager.class);
        this.ppio = new GeoTiffPPIO(this.resources);
    }

    @After
    public void cleanup() {
        if (this.coverage != null) {
            ImageUtilities.disposeImage((RenderedImage)this.coverage.getRenderedImage());
        }
        if (this.reader != null) {
            this.reader.dispose();
        }
        if (this.resource != null) {
            this.resource.delete();
        }
    }

    private GridCoverage2D getCoverage() throws IOException {
        this.coverage = this.reader.read(null);
        HashMap<String, String> properties = new HashMap<String, String>(this.coverage.getProperties());
        properties.put("OriginalFileSource", this.geotiff.getCanonicalPath());
        return new GridCoverageFactory().create((CharSequence)this.coverage.getName(), this.coverage.getRenderedImage(), this.coverage.getEnvelope(), this.coverage.getSampleDimensions(), null, properties);
    }

    @Test
    public void testRawCopy() throws Exception {
        GridCoverage2D coverage = this.getCoverage();
        try (FileOutputStream fos = new FileOutputStream(this.target);){
            this.ppio.encode((Object)coverage, (OutputStream)fos);
        }
        Assert.assertEquals((long)this.geotiff.length(), (long)this.target.length());
    }

    @Test
    public void testCropped() throws Exception {
        this.getCoverage();
        ReferencedEnvelope re = ReferencedEnvelope.reference((ReferencedEnvelope)this.coverage.getEnvelope2D());
        re.expandBy(-0.1);
        this.coverage = new CropCoverage().execute(this.coverage, (Geometry)JTS.toGeometry((ReferencedEnvelope)re), null);
        try (FileOutputStream fos = new FileOutputStream(this.target);){
            this.ppio.encode((Object)this.coverage, (OutputStream)fos);
        }
        Assert.assertNotEquals((long)this.geotiff.length(), (long)this.target.length());
    }

    @Test
    public void testDecodeValidGeoTIFF() throws Exception {
        try (InputStream is = SystemTestData.class.getResourceAsStream("tazbm.tiff");){
            ((WPSResourceManager)Mockito.doAnswer(inv -> {
                this.resource = (GridCoverageReaderResource)inv.getArgument(0, GridCoverageReaderResource.class);
                return null;
            }).when((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
            Object result = this.ppio.decode(is);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(GridCoverage2D.class));
            this.coverage = (GridCoverage2D)result;
            ((WPSResourceManager)Mockito.verify((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
        }
    }

    @Test
    public void testGeoTIFFCompression() throws Exception {
        this.getCoverage();
        try (FileOutputStream fos = new FileOutputStream(this.target);){
            this.ppio.encode((Object)this.coverage, (OutputStream)fos);
        }
        GeoTiffReader reader = new GeoTiffReader((Object)this.target);
        GeoTiffIIOMetadataDecoder metadata = reader.getMetadata();
        IIOMetadataNode rootNode = metadata.getRootNode();
        Assert.assertEquals((Object)"Deflate", (Object)this.getAttributeContent(rootNode, 259, true));
        Assert.assertEquals((Object)"368", (Object)this.getAttributeContent(rootNode, 322, false));
        Assert.assertEquals((Object)"16", (Object)this.getAttributeContent(rootNode, 323, false));
    }

    private IIOMetadataNode getTiffField(Node rootNode, int tag) {
        Node node = rootNode.getFirstChild();
        if (node != null) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node number = node.getAttributes().getNamedItem("number");
                if (number == null || tag != Integer.parseInt(number.getNodeValue())) continue;
                return (IIOMetadataNode)node;
            }
        }
        return null;
    }

    private String getAttributeContent(Node rootNode, int tifTag, boolean isDescription) {
        IIOMetadataNode metadataNode = this.getTiffField(rootNode, tifTag);
        Node node = ((IIOMetadataNode)metadataNode.getFirstChild()).getElementsByTagName("TIFFShorts").item(0).getFirstChild();
        return node.getAttributes().getNamedItem(isDescription ? "description" : "value").getNodeValue();
    }

    @Test
    public void testDecodeValidArcGrid() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("arcGrid.asc");){
            ((WPSResourceManager)Mockito.doAnswer(inv -> {
                this.resource = (GridCoverageReaderResource)inv.getArgument(0, GridCoverageReaderResource.class);
                return null;
            }).when((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
            Object result = this.ppio.decode(is);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(GridCoverage2D.class));
            this.coverage = (GridCoverage2D)result;
            ((WPSResourceManager)Mockito.verify((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
        }
    }

    @Test
    public void testDecodeInvalid() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("empty-shapefile.zip");){
            WPSException exception = (WPSException)Assert.assertThrows(WPSException.class, () -> this.ppio.decode(is));
            Assert.assertEquals((Object)"Could not find the GeoTIFF GT2 format, please check it's in the classpath", (Object)exception.getMessage());
            ((WPSResourceManager)Mockito.verify((Object)this.resources, (VerificationMode)Mockito.never())).addResource((WPSResource)ArgumentMatchers.any());
        }
    }
}

