/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.ppio.ArcGridPPIO;
import org.geoserver.wps.resource.GridCoverageReaderResource;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ArcGridPPIOTest {
    GridCoverage2D coverage;
    GridCoverageReaderResource resource;
    WPSResourceManager resources;
    ArcGridPPIO ppio;

    @Before
    public void prepare() {
        this.resources = (WPSResourceManager)Mockito.mock(WPSResourceManager.class);
        this.ppio = new ArcGridPPIO(this.resources);
    }

    @After
    public void cleanup() {
        if (this.coverage != null) {
            ImageUtilities.disposeImage((RenderedImage)this.coverage.getRenderedImage());
        }
        if (this.resource != null) {
            this.resource.delete();
        }
    }

    @Test
    public void testDecodeValidStream() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("arcGrid.asc");){
            ((WPSResourceManager)Mockito.doAnswer(inv -> {
                this.resource = (GridCoverageReaderResource)inv.getArgument(0, GridCoverageReaderResource.class);
                return null;
            }).when((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
            Object result = this.ppio.decode(is);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(GridCoverage2D.class));
            this.coverage = (GridCoverage2D)result;
            ((WPSResourceManager)Mockito.verify((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
        }
    }

    @Test
    public void testDecodeValidString() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("arcGrid.asc");){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            ((WPSResourceManager)Mockito.doAnswer(inv -> {
                this.resource = (GridCoverageReaderResource)inv.getArgument(0, GridCoverageReaderResource.class);
                return null;
            }).when((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
            Object result = this.ppio.decode(string);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(GridCoverage2D.class));
            this.coverage = (GridCoverage2D)result;
            ((WPSResourceManager)Mockito.verify((Object)this.resources)).addResource((WPSResource)ArgumentMatchers.any(GridCoverageReaderResource.class));
        }
    }

    @Test
    public void testDecodeInvalidStream() throws Exception {
        try (InputStream is = SystemTestData.class.getResourceAsStream("tazbm.tiff");){
            WPSException exception = (WPSException)Assert.assertThrows(WPSException.class, () -> this.ppio.decode(is));
            Assert.assertEquals((Object)"Could not read application/arcgrid coverage", (Object)exception.getMessage());
            ((WPSResourceManager)Mockito.verify((Object)this.resources, (VerificationMode)Mockito.never())).addResource((WPSResource)ArgumentMatchers.any());
        }
    }

    @Test
    public void testDecodeInvalidString() throws Exception {
        WPSException exception = (WPSException)Assert.assertThrows(WPSException.class, () -> this.ppio.decode("foo"));
        Assert.assertEquals((Object)"Could not read application/arcgrid coverage", (Object)exception.getMessage());
        ((WPSResourceManager)Mockito.verify((Object)this.resources, (VerificationMode)Mockito.never())).addResource((WPSResource)ArgumentMatchers.any());
    }
}

