/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Test;
import org.w3c.dom.Document;

public class VectorZonalStatsTest
extends WPSTestSupport {
    static final double EPS = 1.0E-6;
    public static QName BUGSITES = new QName(MockData.SF_URI, "bugsites", MockData.SF_PREFIX);
    public static QName RESTRICTED = new QName(MockData.SF_URI, "restricted", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<SystemTestData.LayerProperty, ReferencedEnvelope> props = new HashMap<SystemTestData.LayerProperty, ReferencedEnvelope>();
        props.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(181985.763, 818014.237, 1973809.464, 8894102.4298, CRS.decode((String)"EPSG:26713", (boolean)true)));
        testData.addVectorLayer(BUGSITES, props, "bugsites.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(RESTRICTED, props, "restricted.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("feature", "http://cite.opengeospatial.org/gmlsf");
    }

    @Test
    public void testStatistics() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:VectorZonalStatistics</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>data</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"sf:bugsites\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>dataAttribute</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>cat</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>zones</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"sf:restricted\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>statistics</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>\n\n";
        Document dom = this.postAsDOM(this.root(), xml);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//feature:restricted[feature:z_cat=2]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"23", (String)"//feature:restricted[feature:z_cat=3]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//feature:restricted[feature:z_cat=4]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"32.0", (String)"//feature:restricted[feature:z_cat=3]/feature:min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"81.0", (String)"//feature:restricted[feature:z_cat=3]/feature:max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1331.0", (String)"//feature:restricted[feature:z_cat=3]/feature:sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"57.869565217391305", (String)"//feature:restricted[feature:z_cat=3]/feature:avg", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"15.120686514855372", (String)"//feature:restricted[feature:z_cat=3]/feature:stddev", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"84.0", (String)"//feature:restricted[feature:z_cat=4]/feature:min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"84.0", (String)"//feature:restricted[feature:z_cat=4]/feature:max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"84.0", (String)"//feature:restricted[feature:z_cat=4]/feature:sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"84.0", (String)"//feature:restricted[feature:z_cat=4]/feature:avg", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//feature:restricted[feature:z_cat=4]/feature:stddev", (Document)dom);
    }
}

