/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.gs.SpatioTemporalZonalStatistics;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;

public class SpatioTemporalStatisticsTests
extends WPSTestSupport {
    public static final double DELTA = 1.0E-4;
    private static QName ZONES = new QName(MockData.SF_URI, "zones", MockData.SF_PREFIX);
    private static QName TEMPERATURES = new QName(MockData.SF_URI, "tempstat", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<SystemTestData.LayerProperty, ReferencedEnvelope> props = new HashMap<SystemTestData.LayerProperty, ReferencedEnvelope>();
        props.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, CRS.decode((String)"EPSG:4326", (boolean)true)));
        testData.addVectorLayer(ZONES, props, "zones.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addRasterLayer(TEMPERATURES, "temperatures.zip", null, null, ((Object)((Object)this)).getClass(), catalog);
        this.setupRasterDimension(TEMPERATURES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
    }

    @Test
    public void testSingleStatistic() throws IOException {
        try (SimpleFeatureIterator features = this.executeProcess("2025-04-16T00:00:00Z,2025-04-18T00:00:00Z,2025-04-20T00:00:00Z", "min");){
            SimpleFeature sf = (SimpleFeature)features.next();
            Assert.assertNotNull((Object)sf.getAttribute("min"));
            Assert.assertNull((Object)sf.getAttribute("max"));
            Assert.assertNull((Object)sf.getAttribute("sum"));
            Assert.assertNull((Object)sf.getAttribute("median"));
        }
    }

    @Test
    public void testTimeRangeStatistics() throws IOException {
        try (SimpleFeatureIterator features = this.executeProcess("2025-04-16T00:00:00Z/2025-04-20T00:00:00Z", "min,max,mean,median,sum");){
            this.assertZoneFeature((SimpleFeature)features.next(), 1L, "0-30", 1000, 0.0, 30.0, 14985.889781348407, 14.985889781348407, 14.955186462402343);
            this.assertZoneFeature((SimpleFeature)features.next(), 2L, "10-20", 1000, 10.0, 20.0, 14985.921039581299, 14.985921039581298, 14.988693809509277);
            this.assertZoneFeature((SimpleFeature)features.next(), 3L, "0-20", 1000, 0.0, 20.0, 9986.017562545836, 9.986017562545838, 9.957139682769775);
            this.assertZoneFeature((SimpleFeature)features.next(), 4L, "10-40", 1000, 10.0, 40.0, 24985.693196296692, 24.98569319629669, 25.014085006713866);
        }
    }

    @Test
    public void testTimeListStatistics() throws IOException {
        try (SimpleFeatureIterator features = this.executeProcess("2025-04-16T00:00:00Z,2025-04-18T00:00:00Z,2025-04-20T00:00:00Z", "min,max,mean,median,sum");){
            this.assertZoneFeature((SimpleFeature)features.next(), 1L, "0-30", 600, 0.0, 30.0, 8993.916089296341, 14.989860148827232, 14.95425542195638);
            this.assertZoneFeature((SimpleFeature)features.next(), 2L, "10-20", 600, 10.0, 20.0, 8994.913537979126, 14.991522563298542, 15.062634627024332);
            this.assertZoneFeature((SimpleFeature)features.next(), 3L, "0-20", 600, 0.0, 20.0, 5994.0438846200705, 9.990073141033454, 9.9647749265035);
            this.assertZoneFeature((SimpleFeature)features.next(), 4L, "10-40", 600, 10.0, 40.0, 14994.685691833496, 24.991142819722494, 25.15604305267334);
        }
    }

    @Test
    public void testTimeStatisticsOnMissingTimes() throws IOException {
        SimpleFeature sf;
        try (SimpleFeatureIterator allTimesFeatures = this.executeProcess("2025-04-16T00:00:00Z,2025-04-17T00:00:00Z,2025-04-18T00:00:00Z,2025-04-19T00:00:00Z,2025-04-20T00:00:00Z", "min");){
            sf = (SimpleFeature)allTimesFeatures.next();
            Assert.assertEquals((String)"Feature count", (long)1000L, (long)((Number)sf.getAttribute("count")).intValue());
        }
        try (SimpleFeatureIterator missingTimesFeatures = this.executeProcess("2025-04-16T00:00:00Z,2025-04-24T00:00:00Z,2025-04-26T00:00:00Z,2025-04-27T00:00:00Z,2025-04-29T00:00:00Z", "min");){
            sf = (SimpleFeature)missingTimesFeatures.next();
            Assert.assertEquals((String)"Feature count", (long)200L, (long)((Number)sf.getAttribute("count")).intValue());
        }
    }

    private SimpleFeatureIterator executeProcess(String timeRange, String stats) throws IOException {
        SpatioTemporalZonalStatistics process = (SpatioTemporalZonalStatistics)applicationContext.getBean(SpatioTemporalZonalStatistics.class);
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName("sf", "zones");
        SimpleFeatureSource featureSource = (SimpleFeatureSource)featureType.getFeatureSource(null, null);
        SimpleFeatureCollection zones = featureSource.getFeatures();
        SimpleFeatureCollection collection = process.execute("sf:tempstat", timeRange, zones, stats);
        return collection.features();
    }

    private void assertZoneFeature(SimpleFeature feature, long expectedZoneId, String expectedRange, int expectedCount, double expectedMin, double expectedMax, double expectedSum, double expectedMean, double expectedMedian) {
        Assert.assertNotNull((String)"Feature should not be null", (Object)feature);
        Geometry geom = (Geometry)feature.getAttribute("z_the_geom");
        Assert.assertNotNull((String)"Geometry should be present", (Object)geom);
        Assert.assertEquals((String)"Expected geometry type", (Object)"Polygon", (Object)geom.getGeometryType());
        Assert.assertEquals((String)"Zone ID", (long)expectedZoneId, (long)((Number)feature.getAttribute("z_zone")).longValue());
        Assert.assertEquals((String)"Range label", (Object)expectedRange, (Object)feature.getAttribute("z_range"));
        Assert.assertEquals((String)"Feature count", (long)expectedCount, (long)((Number)feature.getAttribute("count")).intValue());
        Assert.assertEquals((String)"Min value", (double)expectedMin, (double)((Number)feature.getAttribute("min")).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Max value", (double)expectedMax, (double)((Number)feature.getAttribute("max")).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Sum", (double)expectedSum, (double)((Number)feature.getAttribute("sum")).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Mean", (double)expectedMean, (double)((Number)feature.getAttribute("mean")).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Median", (double)expectedMedian, (double)((Number)feature.getAttribute("median")).doubleValue(), (double)1.0E-4);
    }
}

