/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class RasterZonalStatsTest
extends WPSTestSupport {
    static final double EPS = 1.0E-6;
    public static QName RESTRICTED = new QName(MockData.SF_URI, "restricted", MockData.SF_PREFIX);
    public static QName DEM = new QName(MockData.SF_URI, "sfdem", MockData.SF_PREFIX);
    public static QName TASMANIA_BM_ZONES = new QName(MockData.SF_URI, "BmZones", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
        HashMap<SystemTestData.LayerProperty, Integer> props = new HashMap<SystemTestData.LayerProperty, Integer>();
        props.put(SystemTestData.LayerProperty.SRS, 26713);
        testData.addRasterLayer(DEM, "sfdem.tiff", ".tiff", props, ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(RESTRICTED, props, "restricted.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(TASMANIA_BM_ZONES, props, "tazdem_zones.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("feature", "http://cite.opengeospatial.org/gmlsf");
    }

    @Test
    public void testStatisticsTazDem() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:RasterZonalStatistics</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>data</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</ows:Identifier>\n            <wcs:DomainSubset>\n              <gml:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>145 -43</ows:LowerCorner>\n                <ows:UpperCorner>146 -41</ows:UpperCorner>\n              </gml:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>zones</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + this.getLayerId(TASMANIA_BM_ZONES) + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>statistics</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"14400", (String)"//feature:BmZones[feature:z_cat=1]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7200", (String)"//feature:BmZones[feature:z_cat=2]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7200", (String)"//feature:BmZones[feature:z_cat=3]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"77", (String)"//feature:BmZones[feature:z_cat=4]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"28800", (String)"//feature:BmZones[feature:z_cat=5]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"860.0", (String)"//feature:BmZones[feature:z_cat=4]/feature:min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1357.0", (String)"//feature:BmZones[feature:z_cat=4]/feature:max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"84511.0", (String)"//feature:BmZones[feature:z_cat=4]/feature:sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1097.5454545454547", (String)"//feature:BmZones[feature:z_cat=4]/feature:avg", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"108.38400851341224", (String)"//feature:BmZones[feature:z_cat=4]/feature:stddev", (Document)dom);
    }

    @Test
    public void testStatisticsSfDem() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:RasterZonalStatistics</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>data</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>sf:sfdem</ows:Identifier>\n            <wcs:DomainSubset>\n              <gml:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#26713\">\n                <ows:LowerCorner>589980.0 4913700.0</ows:LowerCorner>\n                <ows:UpperCorner>609000.0 4928010.0</ows:UpperCorner>\n              </gml:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>zones</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"sf:restricted\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"text/xml; subtype=wfs-collection/1.0\">\n      <ows:Identifier>statistics</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"424", (String)"//feature:restricted[feature:z_cat=1]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"218", (String)"//feature:restricted[feature:z_cat=2]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"18629", (String)"//feature:restricted[feature:z_cat=3]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1697", (String)"//feature:restricted[feature:z_cat=4]/feature:count", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1281.0", (String)"//feature:restricted[feature:z_cat=3]/feature:min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1695.0", (String)"//feature:restricted[feature:z_cat=3]/feature:max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2.743144E7", (String)"//feature:restricted[feature:z_cat=3]/feature:sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1472.5127489398305", (String)"//feature:restricted[feature:z_cat=3]/feature:avg", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"93.61336732245832", (String)"//feature:restricted[feature:z_cat=3]/feature:stddev", (Document)dom);
    }
}

