/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetCoveragesValueTest
extends WPSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
    }

    @Test
    public void testNoIntersection() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>14</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>40</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[]}", (Object)result);
    }

    @Test
    public void testBadLayerName() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.TASMANIA_DEM) + ",badName</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>14</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>40</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertTrue((boolean)result.contains("org.geoserver.wps.WPSException: Could not find coverage"));
    }

    @Test
    public void testIntersection() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>145.1332</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>-42.0796</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[55537]}", (Object)result);
    }

    @Test
    public void testIntersectionButNoData() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.TASMANIA_DEM_NODATA) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>145.2199</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>-42.2032</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[]}", (Object)result);
    }

    @Test
    public void testMultipleLayersIntersection() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(WPSTestSupport.TASMANIA_DEM_NODATA) + "," + this.getLayerId(WPSTestSupport.RAIN) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>145.2199</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>-42.2032</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[831.0]}", (Object)result);
    }

    @Test
    public void testIntersectionInMosaicHole() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.HOLE) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>597913</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>5784902</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[0,0,0]}", (Object)result);
    }

    @Test
    public void testIntersectionInLShapedGap() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:GetCoveragesValue</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>name</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + this.getLayerId(MockData.ELSHAPED) + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>x</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>591575</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>y</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>5788071</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"application/json\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        String result = response.getContentAsString();
        Assert.assertEquals((Object)"{\"values\":[0,0,0]}", (Object)result);
    }
}

