/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.gs.GeorectifyCoverage;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class GeorectifyCoverageTest
extends WPSTestSupport {
    @Test
    public void testIsRenderingProcess() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function f = ff.function("gs:GeorectifyCoverage", new Expression[0]);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)(f instanceof RenderingTransformation));
    }

    @Test
    public void testGeorectify() throws IOException, MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException {
        GeorectifyCoverage process = (GeorectifyCoverage)applicationContext.getBean(GeorectifyCoverage.class);
        if (!process.isAvailable()) {
            LOGGER.warning("GDAL utilities are not in the path, skipping the test");
            return;
        }
        BufferedImage image = ImageIO.read(new File("./src/test/resources/rotated-image.png"));
        GridCoverage2D coverage = new GridCoverageFactory().create((CharSequence)"test", (RenderedImage)image, (Bounds)new ReferencedEnvelope(0.0, (double)image.getWidth(), 0.0, (double)image.getHeight(), CRS.decode((String)"EPSG:404000")));
        String gcps = "[[[183, 33], [-74.01183158, 40.70852996]],[[103, 114], [-74.01083751, 40.70754684]],[[459, 298], [-74.00857344, 40.71194565]],[[252, 139], [-74.01053024, 40.70938712]]]";
        Map map = process.execute(coverage, gcps, null, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, null, null, Boolean.valueOf(false), null, null);
        GridCoverage2D warped = (GridCoverage2D)map.get("result");
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)warped.getCoordinateReferenceSystem());
        ReferencedEnvelope envelope = warped.getEnvelope2D();
        Assert.assertEquals((double)-74.0122393, (double)envelope.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)-74.0078822, (double)envelope.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)40.7062701, (double)envelope.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)40.7126021, (double)envelope.getMaxY(), (double)1.0E-6);
    }
}

