/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.easymock.EasyMock;
import org.geoserver.wps.gs.ClassificationStatsPPIO;
import org.geotools.process.classify.ClassificationStats;
import org.geotools.process.vector.FeatureClassStats;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class ClassificationStatsPPIOTest {
    @Test
    public void testSanity() throws Exception {
        List<Range> ranges = Arrays.asList(Range.create((Number)0.0, (boolean)true, (Number)10.0, (boolean)false), Range.create((Number)10.0, (boolean)true, (Number)20.0, (boolean)true));
        StreamingSampleStats s1 = new StreamingSampleStats();
        s1.setStatistic(Statistic.MEAN);
        s1.addRange(ranges.get(0));
        s1.offer(Double.valueOf(10.0));
        StreamingSampleStats s2 = new StreamingSampleStats();
        s2.setStatistic(Statistic.MEAN);
        s2.addRange(ranges.get(0));
        s2.offer(Double.valueOf(10.0));
        StreamingSampleStats[] stats = new StreamingSampleStats[]{s1, s2};
        FeatureClassStats.Results classStats = new FeatureClassStats.Results(ranges, stats);
        ClassificationStatsPPIO ppio = new ClassificationStatsPPIO();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ppio.encode((Object)classStats, (OutputStream)bout);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(bout.toByteArray()));
        Assert.assertEquals((Object)"Results", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/Results/Class[@lowerBound='0.0']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/Results/Class[@lowerBound='10.0']", (Document)doc);
    }

    @Test
    public void testNamespacesNotNull() throws Exception {
        ContentHandler h = (ContentHandler)EasyMock.createNiceMock(ContentHandler.class);
        h.startElement((String)EasyMock.notNull(), (String)EasyMock.notNull(), (String)EasyMock.eq((Object)"Results"), (Attributes)EasyMock.anyObject());
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{h});
        new ClassificationStatsPPIO().encode((Object)this.newStats(), h);
        EasyMock.verify((Object[])new Object[]{h});
    }

    ClassificationStats newStats() {
        List<Range> ranges = Arrays.asList(Range.create((Number)0.0, (boolean)true, (Number)10.0, (boolean)false), Range.create((Number)10.0, (boolean)true, (Number)20.0, (boolean)true));
        StreamingSampleStats s1 = new StreamingSampleStats();
        s1.setStatistic(Statistic.MEAN);
        s1.addRange(ranges.get(0));
        s1.offer(Double.valueOf(10.0));
        StreamingSampleStats s2 = new StreamingSampleStats();
        s2.setStatistic(Statistic.MEAN);
        s2.addRange(ranges.get(0));
        s2.offer(Double.valueOf(10.0));
        StreamingSampleStats[] stats = new StreamingSampleStats[]{s1, s2};
        return new FeatureClassStats.Results(ranges, stats);
    }
}

