/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.vector.BufferFeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class BufferFeatureCollectionTest
extends WPSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testExecutePoint() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        for (int i = 0; i < 2; ++i) {
            b.add((Object)gf.createPoint(new Coordinate((double)i, (double)i)));
            b.add((Object)i);
            features.add(b.buildFeature("" + i));
        }
        Double distance = 500.0;
        BufferFeatureCollection process = new BufferFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, distance, null);
        Assert.assertEquals((long)2L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            for (int i = 0; i < 2; ++i) {
                Geometry expected = gf.createPoint(new Coordinate((double)i, (double)i)).buffer(distance.doubleValue());
                SimpleFeature sf = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            }
        }
    }

    @Test
    public void testExecuteLineString() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
            Coordinate[] array = new Coordinate[4];
            int j = 0;
            for (int i = 0 + numFeatures; i < 4 + numFeatures; ++i) {
                array[j] = new Coordinate((double)i, (double)i);
                ++j;
            }
            b.add((Object)gf.createLineString(array));
            b.add((Object)0);
            features.add(b.buildFeature("" + numFeatures));
        }
        Double distance = 500.0;
        BufferFeatureCollection process = new BufferFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, distance, null);
        Assert.assertEquals((long)5L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
                Coordinate[] array = new Coordinate[4];
                int j = 0;
                for (int i = 0 + numFeatures; i < 4 + numFeatures; ++i) {
                    array[j] = new Coordinate((double)i, (double)i);
                    ++j;
                }
                Geometry expected = gf.createLineString(array).buffer(distance.doubleValue());
                SimpleFeature sf = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            }
        }
    }

    @Test
    public void testExecutePolygon() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
            Coordinate[] array = new Coordinate[4];
            int j = 0;
            for (int i = 0 + numFeatures; i < 3 + numFeatures; ++i) {
                array[j] = new Coordinate((double)i, (double)i);
                ++j;
            }
            array[3] = new Coordinate((double)numFeatures, (double)numFeatures);
            LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(array), new GeometryFactory());
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            features.add(b.buildFeature("" + numFeatures));
        }
        Double distance = 500.0;
        BufferFeatureCollection process = new BufferFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, distance, null);
        Assert.assertEquals((long)5L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
                Coordinate[] array = new Coordinate[4];
                int j = 0;
                for (int i = 0 + numFeatures; i < 3 + numFeatures; ++i) {
                    array[j] = new Coordinate((double)i, (double)i);
                    ++j;
                }
                array[3] = new Coordinate((double)numFeatures, (double)numFeatures);
                LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(array), new GeometryFactory());
                Geometry expected = gf.createPolygon(shell, null).buffer(distance.doubleValue());
                SimpleFeature sf = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            }
        }
    }

    @Test
    public void testExecuteBufferAttribute() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Geometry.class);
        tb.add("integer", Integer.class);
        tb.add("buffer", Double.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
            Coordinate[] array = new Coordinate[4];
            int j = 0;
            for (int i = 0 + numFeatures; i < 3 + numFeatures; ++i) {
                array[j] = new Coordinate((double)i, (double)i);
                ++j;
            }
            array[3] = new Coordinate((double)numFeatures, (double)numFeatures);
            LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(array), new GeometryFactory());
            b.add((Object)gf.createPolygon(shell, null));
            b.add((Object)0);
            b.add((Object)500);
            features.add(b.buildFeature("" + numFeatures));
        }
        BufferFeatureCollection process = new BufferFeatureCollection();
        SimpleFeatureCollection output = process.execute((SimpleFeatureCollection)features, null, "buffer");
        Assert.assertEquals((long)5L, (long)output.size());
        try (SimpleFeatureIterator iterator = output.features();){
            for (int numFeatures = 0; numFeatures < 5; ++numFeatures) {
                Coordinate[] array = new Coordinate[4];
                int j = 0;
                for (int i = 0 + numFeatures; i < 3 + numFeatures; ++i) {
                    array[j] = new Coordinate((double)i, (double)i);
                    ++j;
                }
                array[3] = new Coordinate((double)numFeatures, (double)numFeatures);
                LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(array), new GeometryFactory());
                Geometry expected = gf.createPolygon(shell, null).buffer(500.0);
                SimpleFeature sf = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            }
        }
    }
}

