/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;

public abstract class BaseRasterToVectorTest
extends WPSTestSupport {
    static final double EPS = 1.0E-6;
    public static QName RESTRICTED = new QName(MockData.SF_URI, "restricted", MockData.SF_PREFIX);
    public static QName DEM = new QName(MockData.SF_URI, "sfdem", MockData.SF_PREFIX);
    public static QName TASMANIA_BM_ZONES = new QName(MockData.SF_URI, "BmZones", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
        testData.addRasterLayer(DEM, "sfdem.tiff", TIFF, null, ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<SystemTestData.LayerProperty, ReferencedEnvelope> props = new HashMap<SystemTestData.LayerProperty, ReferencedEnvelope>();
        props.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(181985.763, 818014.237, 1973809.464, 8894102.4298, CRS.decode((String)"EPSG:26713", (boolean)true)));
        testData.addVectorLayer(RESTRICTED, props, "restricted.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(TASMANIA_BM_ZONES, props, "tazdem_zones.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void featureCollectionToShapeFile(SimpleFeatureCollection fc, File destination) throws IOException {
        Utilities.ensureNonNull((String)"fc", (Object)fc);
        Utilities.ensureNonNull((String)"destination", (Object)destination);
        if (destination.exists()) {
            if (destination.isDirectory()) {
                throw new IOException("The provided destination maps to a directory:" + destination);
            }
            if (!destination.canWrite()) {
                throw new IOException("The provided destination maps to an existing file that cannot be deleted:" + destination);
            }
            if (!destination.delete()) {
                throw new IOException("The provided destination maps to an existing file that cannot be deleted:" + destination);
            }
        }
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", destination.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore store = null;
        try {
            store = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            store.createSchema((SimpleFeatureType)fc.getSchema());
            SimpleFeatureStore featureStore = (SimpleFeatureStore)store.getFeatureSource(((SimpleFeatureType)fc.getSchema()).getName());
            try (Transaction transaction = featureStore.getTransaction();){
                featureStore.addFeatures((FeatureCollection)fc);
                transaction.commit();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "", e);
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }
}

