/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.easymock.EasyMock;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSInfoImpl;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.WPSXStreamLoader;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.geometry.GeometryProcessFactory;
import org.geotools.process.raster.RasterProcessFactory;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WPSXStreamLoaderTest
extends WPSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testCreateFromScratch() throws Exception {
        WPSXStreamLoader loader = (WPSXStreamLoader)GeoServerExtensions.bean(WPSXStreamLoader.class);
        WPSInfo wps = loader.createServiceFromScratch(null);
        Assert.assertNotNull((Object)wps);
        Assert.assertEquals((Object)"WPS", (Object)wps.getName());
    }

    @Test
    public void testInit() throws Exception {
        WPSXStreamLoader loader = (WPSXStreamLoader)GeoServerExtensions.bean(WPSXStreamLoader.class);
        WPSInfoImpl wps = new WPSInfoImpl();
        loader.initializeService((ServiceInfo)wps);
        Assert.assertEquals((Object)"WPS", (Object)wps.getName());
    }

    @Test
    public void testBackFormatXmlComatibility() throws Exception {
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        URL url = Thread.currentThread().getContextClassLoader().getResource("org/geoserver/wps/");
        File file = URLs.urlToFile((URL)url);
        WPSXStreamLoader loader = new WPSXStreamLoader(new GeoServerResourceLoader(file));
        WPSInfo wps = (WPSInfo)loader.load(gs);
        boolean found1 = false;
        boolean found2 = false;
        for (ProcessGroupInfo pg : wps.getProcessGroups()) {
            if (pg.getFactoryClass().getName().equals("org.geoserver.wps.DeprecatedProcessFactory")) {
                Assert.assertFalse((boolean)pg.isEnabled());
                found1 = true;
            }
            if (pg.getFilteredProcesses() == null) continue;
            for (Object opi : pg.getFilteredProcesses()) {
                Assert.assertTrue((boolean)(opi instanceof ProcessInfo));
            }
            if (!pg.getFactoryClass().getName().equals("org.geoserver.wps.jts.SpringBeanProcessFactory")) continue;
            Assert.assertTrue((boolean)pg.isEnabled());
            Assert.assertEquals((Object)((ProcessInfo)pg.getFilteredProcesses().get(0)).getName().toString(), (Object)"gs:GeorectifyCoverage");
            Assert.assertEquals((Object)((ProcessInfo)pg.getFilteredProcesses().get(1)).getName().toString(), (Object)"gs:GetFullCoverage");
            Assert.assertEquals((Object)((ProcessInfo)pg.getFilteredProcesses().get(2)).getName().toString(), (Object)"gs:Import");
            found2 = true;
        }
        Assert.assertTrue((boolean)found1);
        Assert.assertTrue((boolean)found2);
    }

    @Test
    public void testPersistValidators() throws Exception {
        ProcessGroupInfoImpl geoGroup = new ProcessGroupInfoImpl();
        geoGroup.setFactoryClass(GeometryProcessFactory.class);
        ProcessInfoImpl area = new ProcessInfoImpl();
        area.setEnabled(Boolean.valueOf(true));
        area.setName((Name)new NameImpl("geo", "Area"));
        area.getValidators().put((Object)"geom", (Object)new MaxSizeValidator(10));
        geoGroup.getFilteredProcesses().add(area);
        ProcessGroupInfoImpl rasGroup = new ProcessGroupInfoImpl();
        rasGroup.setFactoryClass(RasterProcessFactory.class);
        ProcessInfoImpl contour = new ProcessInfoImpl();
        contour.setEnabled(Boolean.valueOf(true));
        contour.setName((Name)new NameImpl("ras", "Contour"));
        contour.getValidators().put((Object)"levels", (Object)new NumberRangeValidator(new NumberRange(Double.class, (Number)-8000.0, (Number)8000.0)));
        contour.getValidators().put((Object)"levels", (Object)new MultiplicityValidator(3));
        rasGroup.getFilteredProcesses().add(contour);
        File root = new File("./target");
        WPSXStreamLoader loader = new WPSXStreamLoader(new GeoServerResourceLoader(root));
        WPSInfo wps = loader.createServiceFromScratch(null);
        wps.getProcessGroups().add(geoGroup);
        wps.getProcessGroups().add(rasGroup);
        loader.save((ServiceInfo)wps, this.getGeoServer(), Files.asResource((File)root));
        String xml = FileUtils.readFileToString((File)new File(root, "wps.xml"), (String)"UTF-8");
        Document dom = this.dom(xml);
        String baseGeomPath = "/wps/processGroups/processGroup[factoryClass='" + GeometryProcessFactory.class.getName() + "']/filteredProcesses/accessInfo";
        XMLAssert.assertXpathExists((String)baseGeomPath, (Document)dom);
        String geoAreaBase = baseGeomPath + "[name='geo:Area']/validators/entry[@key='geom']";
        XMLAssert.assertXpathExists((String)geoAreaBase, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"10", (String)(geoAreaBase + "/maxSizeValidator/maxSizeMB"), (Document)dom);
        String baseRasPath = "/wps/processGroups/processGroup[factoryClass='" + RasterProcessFactory.class.getName() + "']/filteredProcesses/accessInfo";
        XMLAssert.assertXpathExists((String)baseRasPath, (Document)dom);
        String rasContourBase = baseRasPath + "[name='ras:Contour']";
        XMLAssert.assertXpathExists((String)rasContourBase, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)(rasContourBase + "/validators/entry[@key='levels']/maxMultiplicityValidator/maxInstances"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-8000.0", (String)(rasContourBase + "/validators/entry[@key='levels']/rangeValidator/range/minValue"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"8000.0", (String)(rasContourBase + "/validators/entry[@key='levels']/rangeValidator/range/maxValue"), (Document)dom);
        WPSInfo wps2 = (WPSInfo)loader.load(this.getGeoServer(), Files.asResource((File)root));
        Assert.assertEquals((Object)wps, (Object)wps2);
    }

    Document dom(String xml) throws ParserConfigurationException, SAXException, IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());){
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            return document;
        }
    }

    @Test
    public void testLoadFromXML() throws Exception {
        WPSInfo wpsInfo = this.loadFromXml("wps-test.xml");
        Assert.assertNotNull((Object)wpsInfo);
    }

    @Test
    public void testLoadFromXMLWithUnknownProcessGroups() throws Exception {
        WPSInfo wpsInfo = this.loadFromXml("wps-test-error.xml");
        Assert.assertNotNull((Object)wpsInfo);
        boolean foundGeometryFactory = false;
        boolean foundMissingProcessFactory = false;
        boolean foundRasterFactory = false;
        for (ProcessGroupInfo pg : wpsInfo.getProcessGroups()) {
            if (pg.getFactoryClass().getName().equals("org.geotools.process.geometry.GeometryProcessFactory")) {
                Assert.assertTrue((boolean)pg.isEnabled());
                foundGeometryFactory = true;
            }
            if (pg.getFactoryClass().getName().equals("org.geoserver.wps.MissingProcessFactory")) {
                foundMissingProcessFactory = true;
            }
            if (!pg.getFactoryClass().getName().equals("org.geotools.process.raster.RasterProcessFactory")) continue;
            Assert.assertTrue((boolean)pg.isEnabled());
            foundRasterFactory = true;
        }
        Assert.assertTrue((boolean)foundGeometryFactory);
        Assert.assertTrue((boolean)foundRasterFactory);
        Assert.assertFalse((boolean)foundMissingProcessFactory);
    }

    @Test
    public void testLoadFromXMLWithWorkSpace() throws Exception {
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setId("wps-load-test-workspace-id");
        workspace.setName("wps-load-test-workspace-name");
        workspace.setDefault(false);
        catalog.add((WorkspaceInfo)workspace);
        WPSInfo wpsInfo = this.loadFromXml("wps-test-workspace.xml");
        Assert.assertNotNull((Object)wpsInfo);
        Assert.assertNotNull((Object)wpsInfo.getWorkspace());
        Assert.assertEquals((Object)"wps-load-test-workspace-id", (Object)wpsInfo.getWorkspace().getId());
        try {
            Assert.assertEquals((Object)"wps-load-test-workspace-name", (Object)wpsInfo.getWorkspace().getName());
        }
        catch (NullPointerException exception) {
            Assert.fail((String)"NULL proxy");
        }
    }

    private WPSInfo loadFromXml(String resource) throws Exception {
        XStreamPersisterFactory factory = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister xp = factory.createXMLPersister();
        WPSXStreamLoader loader = (WPSXStreamLoader)GeoServerExtensions.bean(WPSXStreamLoader.class);
        loader.initXStreamPersister(xp, this.getGeoServer());
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);){
            WPSInfo wPSInfo = (WPSInfo)xp.load(is, WPSInfo.class);
            return wPSInfo;
        }
    }
}

