/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.RawProcess;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class RawInputOutputTest
extends WPSTestSupport {
    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("ani", "http://geoserver.org/wps/animation");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
        this.getGeoServer().save(global);
    }

    @Test
    public void testGetCapabilities() throws Exception {
        Document d = this.getAsDOM("wps?service=wps&request=getcapabilities");
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wps:Process[ows:Identifier='gs:Raw'])", d));
    }

    @Test
    public void testDescribeProcess() throws Exception {
        Document d = this.getAsDOM(this.root() + "service=wps&request=describeprocess&identifier=gs:Raw");
        String inputBase = "/wps:ProcessDescriptions/ProcessDescription/DataInputs";
        XMLAssert.assertXpathEvaluatesTo((String)"application/json", (String)(inputBase + "/Input[1]/ComplexData/Default/Format/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"application/json", (String)(inputBase + "/Input[1]/ComplexData/Supported/Format[1]/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml", (String)(inputBase + "/Input[1]/ComplexData/Supported/Format[2]/MimeType/child::text()"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(" + inputBase + "/Input[ows:Identifier='outputMimeType'])"), (Document)d);
        String outputBase = "/wps:ProcessDescriptions/ProcessDescription/ProcessOutputs";
        XMLAssert.assertXpathEvaluatesTo((String)"application/json", (String)(outputBase + "/Output/ComplexOutput/Default/Format/MimeType"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"application/json", (String)(outputBase + "/Output/ComplexOutput/Supported/Format[1]/MimeType"), (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml", (String)(outputBase + "/Output/ComplexOutput/Supported/Format[2]/MimeType"), (Document)d);
    }

    @Test
    public void testExecuteSynchDocument() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Raw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>data</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/json\"><![CDATA[ABCDE]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='false'><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document d = this.postAsDOM("wps", xml);
        Assert.assertEquals((Object)"wps:ExecuteResponse", (Object)d.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"/wps:ExecuteResponse/wps:Status/wps:ProcessSucceeded", (Document)d);
    }

    @Test
    public void testExecuteSynchRaw() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Raw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>data</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/json\"><![CDATA[ABCDE]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput mimeType=\"text/xml\"><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse("wps", xml);
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
        Assert.assertEquals((Object)"ABCDE", (Object)response.getContentAsString());
    }

    @Test
    public void testExecuteEmbeddedXML() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Raw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>data</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"text/xml\" xmlns:ani=\"http://geoserver.org/wps/animation\">  <ani:Layer>\n    <ani:Name>test</ani:Name>\n    <ani:Parameter key=\"CQL_FILTER\">sun_elevation%3C51</ani:Parameter>\n  </ani:Layer>\n</wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:RawDataOutput mimeType=\"text/xml\"><ows:Identifier>result</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse("wps", xml);
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        XMLAssert.assertXpathEvaluatesTo((String)"test", (String)"//ani:Layer/ani:Name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CQL_FILTER", (String)"//ani:Layer/ani:Parameter/@key", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sun_elevation%3C51", (String)"//ani:Layer/ani:Parameter", (Document)dom);
    }

    @Test
    public void testExecuteAsynch() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Raw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>data</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/json\"><![CDATA[ABCDE]]></wps:ComplexData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument storeExecuteResponse='true' status='true'><wps:Output asReference='true'><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:ProcessAccepted", (Document)dom);
        String fullStatusLocation = xp.evaluate("//wps:ExecuteResponse/@statusLocation", dom);
        String statusLocation = fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> {
            Document wd = this.getAsDOM(statusLocation);
            return this.countMatches(wd, "//wps:Status/wps:ProcessAccepted") == 0 && this.countMatches(wd, "//wps:Status/wps:ProcessStarted") == 0 && this.countMatches(wd, "//wps:Status/wps:ProcessQueued") == 0;
        });
        dom = this.getAsDOM(statusLocation);
        Assert.assertEquals((long)1L, (long)this.countMatches(dom, "//wps:Status/wps:ProcessSucceeded"));
        String fullReference = xp.evaluate("//wps:ProcessOutputs/wps:Output[ows:Identifier='result']/wps:Reference/@href", dom);
        String reference = fullReference.substring(fullReference.indexOf(63) - 3);
        MockHttpServletResponse response = this.getAsServletResponse(reference);
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"ABCDE", (Object)response.getContentAsString());
    }

    @Test
    public void testReturnNull() throws Exception {
        String xml = "<wps:Execute service='WPS' version='1.0.0' xmlns:wps='http://www.opengis.net/wps/1.0.0' xmlns:ows='http://www.opengis.net/ows/1.1'><ows:Identifier>gs:Raw</ows:Identifier><wps:DataInputs><wps:Input><ows:Identifier>data</ows:Identifier><wps:Data><wps:ComplexData mimeType=\"application/json\"><![CDATA[ABCDE]]></wps:ComplexData></wps:Data></wps:Input><wps:Input><ows:Identifier>returnNull</ows:Identifier><wps:Data><wps:LiteralData>true</wps:LiteralData></wps:Data></wps:Input></wps:DataInputs><wps:ResponseForm><wps:ResponseDocument><wps:Output><ows:Identifier>result</ows:Identifier></wps:Output></wps:ResponseDocument></wps:ResponseForm></wps:Execute>";
        Document dom = this.postAsDOM("wps", xml);
        this.checkValidationErrors(dom);
        Assert.assertEquals((long)1L, (long)this.countMatches(dom, "//wps:Status/wps:ProcessSucceeded"));
        Assert.assertEquals((Object)"1", (Object)xp.evaluate("count(//wps:ProcessOutputs/wps:Output[ows:Identifier='result']/wps:Data/wps:ComplexData)", dom));
        Assert.assertEquals((Object)"0", (Object)xp.evaluate("count(//wps:ProcessOutputs/wps:Output[ows:Identifier='result']/wps:Data/wps:ComplexData/*)", dom));
    }

    static {
        Processors.addProcessFactory((ProcessFactory)RawProcess.getFactory());
    }
}

