/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.util.List;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractProcessStoreTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    protected ProcessStatusStore store;
    protected ExecutionStatus s1;
    protected ExecutionStatus s2;
    protected ExecutionStatus s3;
    protected ExecutionStatus s4;

    @Before
    public void setup() throws IOException {
        this.store = this.buildStore();
        this.s1 = new ExecutionStatus((Name)new NameImpl("test1"), "abcde1", false);
        this.s2 = new ExecutionStatus((Name)new NameImpl("test2"), "abcde2", false);
        this.s2.setException((Throwable)new Exception());
        this.s3 = new ExecutionStatus((Name)new NameImpl("test3"), "abcde3", false);
        this.s3.setPhase(ProcessState.RUNNING);
        this.s3.setProgress(50.0f);
        this.s3.setTask("Having fun");
        this.s4 = new ExecutionStatus((Name)new NameImpl("test3"), "abcde4", false);
        this.s4.setPhase(ProcessState.RUNNING);
        this.s4.setProgress(70.0f);
        this.s4.setTask("Fun is almost over");
        this.fillStore();
    }

    protected abstract ProcessStatusStore buildStore() throws IOException;

    protected void fillStore() {
        this.store.save(this.s1);
        this.store.save(this.s2);
        this.store.save(this.s3);
        this.store.save(this.s4);
    }

    @Test
    public void testFilter() throws CQLException {
        this.checkFiltered(this.store, this.query("processName = 'test1'"), this.s1);
        this.checkFiltered(this.store, this.query("phase = 'RUNNING'"), this.s3, this.s4);
        this.checkFiltered(this.store, this.query("progress > 30"), this.s3, this.s4);
        this.checkFiltered(this.store, this.query("strToLowerCase(phase) = 'running'"), this.s3, this.s4);
        this.checkFiltered(this.store, this.query("strToLowerCase(phase) = 'running' AND progress > 30"), this.s3, this.s4);
    }

    @Test
    public void testPaging() throws CQLException {
        this.checkFiltered(this.store, this.query("processName = 'test1'", 0, 1, new SortBy[0]), this.s1);
        this.checkFiltered(this.store, this.query("processName = 'test1'", 1, 1, new SortBy[0]), new ExecutionStatus[0]);
        this.checkFiltered(this.store, this.query("phase = 'RUNNING'", 0, 1, this.asc("progress")), this.s3);
        this.checkFiltered(this.store, this.query("phase = 'RUNNING'", 1, 1, this.asc("progress")), this.s4);
        this.checkFiltered(this.store, this.query("phase = 'RUNNING'", 0, 1, this.desc("progress")), this.s4);
        this.checkFiltered(this.store, this.query("phase = 'RUNNING'", 1, 1, this.desc("progress")), this.s3);
        String lowercaseRunning = "strToLowerCase(phase) = 'running'";
        this.checkFiltered(this.store, this.query(lowercaseRunning), this.s3, this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunning, 0, 1, this.asc("progress")), this.s3);
        this.checkFiltered(this.store, this.query(lowercaseRunning, 1, 1, this.asc("progress")), this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunning, 0, 1, this.desc("progress")), this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunning, 1, 1, this.desc("progress")), this.s3);
        String lowercaseRunningProgress = "strToLowerCase(phase) = 'running' AND progress > 30";
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress), this.s3, this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress), this.s3, this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress, 0, 1, this.asc("progress")), this.s3);
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress, 1, 1, this.asc("progress")), this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress, 0, 1, this.desc("progress")), this.s4);
        this.checkFiltered(this.store, this.query(lowercaseRunningProgress, 1, 1, this.desc("progress")), this.s3);
    }

    private SortBy asc(String propertyName) {
        return FF.sort(propertyName, SortOrder.ASCENDING);
    }

    private SortBy desc(String propertyName) {
        return FF.sort(propertyName, SortOrder.DESCENDING);
    }

    protected void checkFiltered(ProcessStatusStore store, Query query, ExecutionStatus ... statuses) {
        List filtered = store.list(query);
        this.checkContains(filtered, statuses);
    }

    private Query query(String cql) throws CQLException {
        return this.query(cql, 0, Integer.MAX_VALUE, new SortBy[0]);
    }

    private Query query(String cql, int startIndex, int maxFeatures, SortBy ... sortBy) throws CQLException {
        Filter filter = ECQL.toFilter((String)cql);
        Query query = new Query(null, filter);
        query.setStartIndex(Integer.valueOf(startIndex));
        query.setMaxFeatures(maxFeatures);
        query.setSortBy(sortBy);
        return query;
    }

    private void checkContains(List<ExecutionStatus> filtered, ExecutionStatus ... statuses) {
        Assert.assertEquals((long)statuses.length, (long)filtered.size());
        for (ExecutionStatus status : statuses) {
            Assert.assertTrue((boolean)filtered.contains(status));
        }
    }

    @Test
    public void testDelete() throws CQLException {
        Assert.assertEquals((long)1L, (long)this.store.remove(CQL.toFilter((String)"processName = 'test1'")));
        this.checkContains(this.store.list(Query.ALL), this.s2, this.s3, this.s4);
        Assert.assertEquals((long)2L, (long)this.store.remove(CQL.toFilter((String)"progress > 30")));
        this.checkContains(this.store.list(Query.ALL), this.s2);
        Assert.assertEquals((long)1L, (long)this.store.remove(CQL.toFilter((String)"phase = 'FAILED'")));
        this.checkContains(this.store.list(Query.ALL), new ExecutionStatus[0]);
    }

    @Test
    public void testIsolated() {
        this.store.remove((Filter)Filter.INCLUDE);
        ExecutionStatus status = new ExecutionStatus((Name)new NameImpl("test"), "abcde", false);
        this.store.save(status);
        List statuses = this.store.list(Query.ALL);
        Assert.assertEquals((long)1L, (long)statuses.size());
        Assert.assertEquals((String)"incorrect status", (Object)status, statuses.get(0));
        Assert.assertNotSame((Object)status, statuses.get(0));
    }
}

