/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.xml;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.text.StringEscapeUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.LocalWorkspaceCatalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.xml.v1_0_0.WCSParserDelegate;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.geoserver.wfs.xml.v1_0_0.GetFeatureTypeBinding;
import org.geoserver.wps.xml.ComplexDataTypeBinding;
import org.geotools.wfs.WFSParserDelegate;
import org.geotools.wfs.v1_0.WFS;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.wfs.v2_0.bindings.CopyingHandler;
import org.geotools.wps.WPS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ParserDelegate;
import org.geotools.xsd.ParserDelegate2;
import org.geotools.xsd.XSDParserDelegate;
import org.geotools.xsd.impl.Handler;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class WPSConfiguration
extends org.geotools.wps.WPSConfiguration {
    protected void registerBindings(Map<QName, Object> bindings) {
        super.registerBindings(bindings);
        bindings.put(WPS.ComplexDataType, ComplexDataTypeBinding.class);
    }

    protected void configureContext(MutablePicoContainer container) {
        super.configureContext(container);
        container.registerComponentInstance((Object)new org.geoserver.wcs.xml.v1_1_1.WCSParserDelegate());
        container.registerComponentInstance((Object)new WCSParserDelegate());
        container.registerComponentInstance((Object)new org.geoserver.wcs2_0.xml.WCSParserDelegate());
        container.registerComponentInstance((Object)container);
        Object wfs = container.getComponentInstanceOfType(WFSParserDelegate.class);
        container.unregisterComponentByInstance(wfs);
        container.registerComponentInstance((Object)new WPSInternalXSDParserDelegate((Configuration)new WFSConfiguration(){

            protected void configureBindings(MutablePicoContainer container) {
                super.configureBindings(container);
                container.registerComponentImplementation((Object)WFS.GetFeatureType, GetFeatureTypeBinding.class);
            }
        }, (NamespaceSupport)new CatalogNamespaceSupport((Catalog)GeoServerExtensions.bean(LocalWorkspaceCatalog.class))));
        container.registerComponentInstance((Object)new org.geoserver.wfs.xml.v2_0.WFSParserDelegate());
        container.registerComponentImplementation(ComplexDataHandler.class);
    }

    private static final class WPSInternalXSDParserDelegate
    extends XSDParserDelegate {
        public WPSInternalXSDParserDelegate(Configuration configuration, NamespaceSupport nsSupport) {
            super(configuration);
            this.handler.getNamespaceSupport().add(nsSupport);
        }
    }

    public static class ComplexDataHandler
    extends CopyingHandler
    implements ParserDelegate,
    ParserDelegate2 {
        private List<ParserDelegate> delegates;
        private final PicoContainer container;
        String result = null;

        public ComplexDataHandler(NamespaceSupport ns, PicoContainer container) {
            super(ns);
            this.container = container;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            String escapedXML = StringEscapeUtils.escapeXml10((String)new String(ch, start, length));
            this.buffer.append(escapedXML);
        }

        public boolean canHandle(QName elementName, Attributes attributes, Handler handler, Handler parent) {
            if (parent == null || !"ComplexData".equals(parent.getComponent().getName())) {
                return false;
            }
            for (ParserDelegate delegate : this.getDelegates()) {
                if (delegate instanceof ComplexDataHandler || !(delegate instanceof ParserDelegate) || !delegate.canHandle(elementName, attributes, handler, parent)) continue;
                return false;
            }
            return true;
        }

        public void endDocument() throws SAXException {
            this.result = this.buffer != null ? this.buffer.toString() : null;
            this.buffer = null;
        }

        public Object getParsedObject() {
            return this.result;
        }

        public List<ParserDelegate> getDelegates() {
            if (this.delegates == null) {
                this.delegates = this.container.getComponentInstancesOfType(ParserDelegate.class);
            }
            return this.delegates;
        }
    }
}

