/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.springframework.validation.Validator;

public class Validators {
    public static List<Validator> filterOutClasses(Collection<Validator> validators, Class<?> ... filteredClasses) {
        if (validators == null) {
            return null;
        }
        ArrayList<Validator> result = new ArrayList<Validator>();
        for (Validator v : validators) {
            Class<?> validatorClass = v.getClass();
            boolean skip = false;
            for (Class<?> filteredClass : filteredClasses) {
                if (!filteredClass.isAssignableFrom(validatorClass)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            result.add(v);
        }
        return result;
    }

    public static int getMaxSizeMB(Collection<Validator> validators) {
        int maxSize = Integer.MAX_VALUE;
        if (validators != null) {
            for (Validator v : validators) {
                if (!(v instanceof MaxSizeValidator)) continue;
                MaxSizeValidator ms = (MaxSizeValidator)v;
                int msSize = ms.getMaxSizeMB();
                maxSize = Math.min(maxSize, msSize);
            }
        }
        if (maxSize <= 0 || maxSize == Integer.MAX_VALUE) {
            return -1;
        }
        return maxSize;
    }
}

