/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import java.util.Date;
import org.geoserver.wps.validator.ObjectSizeEstimator;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class FeatureSizeEstimator
implements ObjectSizeEstimator {
    @Override
    public long getSizeOf(Object object) {
        SimpleFeatureCollection fc;
        int count;
        if (object instanceof SimpleFeature) {
            SimpleFeatureType ft = ((SimpleFeature)object).getFeatureType();
            return this.estimateSizeByFeatureType(ft);
        }
        if (object instanceof SimpleFeatureCollection && (count = (fc = (SimpleFeatureCollection)object).size()) > 0) {
            SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
            return count + this.estimateSizeByFeatureType(ft);
        }
        return 0L;
    }

    private int estimateSizeByFeatureType(SimpleFeatureType ft) {
        int bytes = 0;
        for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
            bytes += 16;
            Class type = ad.getType().getBinding();
            if (Point.class.isAssignableFrom(type)) {
                bytes += 44;
                continue;
            }
            if (Geometry.class.isAssignableFrom(type)) {
                bytes += 1052;
                continue;
            }
            if (Number.class.isAssignableFrom(type)) {
                if (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    bytes += 8;
                    continue;
                }
                if (Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    bytes += 4;
                    continue;
                }
                if (Short.class.isAssignableFrom(type)) {
                    bytes += 2;
                    continue;
                }
                if (!Byte.class.isAssignableFrom(type)) continue;
                ++bytes;
                continue;
            }
            if (Character.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
                ++bytes;
                continue;
            }
            if (Date.class.isAssignableFrom(type)) {
                bytes += 8;
                continue;
            }
            bytes += 80;
        }
        return bytes;
    }
}

