/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.process;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.process.ProcessFilter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoServerProcessors
implements ApplicationContextAware {
    private static List<ProcessFilter> filters;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        filters = GeoServerExtensions.extensions(ProcessFilter.class, (ApplicationContext)appContext);
    }

    public static Set<ProcessFactory> getProcessFactories() {
        Set factories = Processors.getProcessFactories();
        LinkedHashSet<ProcessFactory> result = new LinkedHashSet<ProcessFactory>();
        for (ProcessFactory pf : factories) {
            if ((pf = GeoServerProcessors.applyFilters(pf)) == null) continue;
            result.add(pf);
        }
        return result;
    }

    private static ProcessFactory applyFilters(ProcessFactory pf) {
        block2: {
            ProcessFilter filter;
            if (pf == null) {
                return null;
            }
            if (filters == null) break block2;
            Iterator<ProcessFilter> iterator = filters.iterator();
            while (iterator.hasNext() && (pf = (filter = iterator.next()).filterFactory(pf)) != null) {
            }
        }
        return pf;
    }

    public static ProcessFactory createProcessFactory(Name name, boolean applyFilters) {
        ProcessFactory pf = Processors.createProcessFactory((Name)name);
        if (applyFilters) {
            pf = GeoServerProcessors.applyFilters(pf);
        }
        if (pf != null && !pf.getNames().contains(name)) {
            pf = null;
        }
        return pf;
    }

    public static Process createProcess(Name name) {
        ProcessFactory factory = GeoServerProcessors.createProcessFactory(name, false);
        if (factory == null) {
            return null;
        }
        return factory.create(name);
    }

    public static ProcessFactory getProcessFactory(Class<?> factoryClass, boolean applyFilters) {
        Set factories = Processors.getProcessFactories();
        for (ProcessFactory pf : factories) {
            if (!factoryClass.equals(pf.getClass())) continue;
            if (!applyFilters) {
                return pf;
            }
            pf = GeoServerProcessors.applyFilters(pf);
            return pf;
        }
        return null;
    }
}

