/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.wcs.responses.GeoTiffWriterHelper;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.ppio.BinaryPPIO;
import org.geoserver.wps.resource.GridCoverageReaderResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.process.ProcessException;
import org.geotools.util.logging.Logging;

public class GeoTiffPPIO
extends BinaryPPIO
implements ExtensionPriority {
    protected static final String TILE_WIDTH_KEY = "tilewidth";
    protected static final String TILE_HEIGHT_KEY = "tileheight";
    protected static final String COMPRESSION_KEY = "compression";
    protected static final String WRITENODATA_KEY = "writenodata";
    private static final Set<String> SUPPORTED_PARAMS = new HashSet<String>();
    private static final String SUPPORTED_PARAMS_LIST;
    private static final String DEFAULT_COMPRESSION = "Deflate";
    private static final Logger LOGGER;
    private final WPSResourceManager resources;

    protected GeoTiffPPIO(WPSResourceManager resources) {
        super(GridCoverage2D.class, GridCoverage2D.class, "image/tiff");
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(InputStream input) throws Exception {
        GridCoverage2D gridCoverage2D;
        block6: {
            File root = new File(System.getProperty("java.io.tmpdir", "."));
            File f = File.createTempFile("wps", "tiff", root);
            GridCoverageReaderResource resource = null;
            try {
                FileUtils.copyInputStreamToFile((InputStream)input, (File)f);
                AbstractGridFormat format = GridFormatFinder.findFormat((Object)f);
                if (format instanceof UnknownFormat) {
                    throw new WPSException("Could not find the GeoTIFF GT2 format, please check it's in the classpath");
                }
                AbstractGridCoverage2DReader reader = format.getReader((Object)f);
                resource = new GridCoverageReaderResource(reader, f);
                gridCoverage2D = reader.read(null);
                if (resource != null) {
                    this.resources.addResource(resource);
                    break block6;
                }
                f.delete();
            }
            catch (Throwable throwable) {
                if (resource != null) {
                    this.resources.addResource(resource);
                } else {
                    f.delete();
                }
                throw throwable;
            }
        }
        return gridCoverage2D;
    }

    private Map<String, Object> getDefaultWritingParams(Object value) throws IOException {
        GridCoverage2D coverage = (GridCoverage2D)value;
        RenderedImage renderedImage = coverage.getRenderedImage();
        int tileWidth = renderedImage.getTileWidth();
        int tileHeight = renderedImage.getTileHeight();
        GridEnvelope gr = coverage.getGridGeometry().getGridRange();
        if (gr.getSpan(0) < tileWidth) {
            tileWidth = gr.getSpan(0);
        }
        if (gr.getSpan(1) < tileHeight) {
            tileHeight = gr.getSpan(1);
        }
        HashMap<String, Object> defaultsMap = new HashMap<String, Object>();
        defaultsMap.put(TILE_WIDTH_KEY, String.valueOf(tileWidth));
        defaultsMap.put(TILE_HEIGHT_KEY, String.valueOf(tileHeight));
        defaultsMap.put(COMPRESSION_KEY, DEFAULT_COMPRESSION);
        return defaultsMap;
    }

    @Override
    public void encode(Object value, OutputStream os) throws Exception {
        this.encode(value, this.getDefaultWritingParams(value), os);
    }

    @Override
    public void encode(Object value, Map<String, Object> encodingParameters, OutputStream os) throws Exception {
        GridCoverage2D coverage = (GridCoverage2D)value;
        GeoTiffWriterHelper helper = new GeoTiffWriterHelper(coverage);
        this.setEncodingParams(helper, encodingParameters);
        try {
            helper.write(os);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private void setEncodingParams(GeoTiffWriterHelper helper, Map<String, Object> encodingParameters) {
        if (encodingParameters != null && !encodingParameters.isEmpty()) {
            ParameterValueGroup geotoolsWriteParams;
            block12: {
                for (String encodingParam : encodingParameters.keySet()) {
                    if (SUPPORTED_PARAMS.contains(encodingParam) || !LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.warning("The specified parameter will be ignored: " + encodingParam + " Supported parameters are in the list: " + SUPPORTED_PARAMS_LIST);
                }
                GeoTiffWriteParams writeParams = helper.getImageIoWriteParams();
                if (writeParams != null) {
                    block11: {
                        if (encodingParameters.containsKey(TILE_WIDTH_KEY) && encodingParameters.containsKey(TILE_HEIGHT_KEY)) {
                            String tileWidth = (String)encodingParameters.get(TILE_WIDTH_KEY);
                            String tileHeight = (String)encodingParameters.get(TILE_HEIGHT_KEY);
                            try {
                                int tw = Integer.parseInt(tileWidth);
                                int th = Integer.parseInt(tileHeight);
                                writeParams.setTilingMode(2);
                                writeParams.setTiling(tw, th);
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOGGER.isLoggable(Level.INFO)) break block11;
                                LOGGER.info("Specified tiling parameters are not valid. tileWidth = " + tileWidth + " tileHeight = " + tileHeight);
                            }
                        }
                    }
                    if (encodingParameters.containsKey(COMPRESSION_KEY)) {
                        String compressionType = (String)encodingParameters.get(COMPRESSION_KEY);
                        writeParams.setCompressionMode(2);
                        writeParams.setCompressionType(compressionType);
                        if (encodingParameters.containsKey("quality")) {
                            String compressionQuality = (String)encodingParameters.get("quality");
                            try {
                                writeParams.setCompressionQuality(Float.parseFloat(compressionQuality));
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOGGER.isLoggable(Level.INFO)) break block12;
                                LOGGER.info("Specified quality is not valid (it should be in the range [0,1]). compressionQuality = " + compressionQuality);
                            }
                        }
                    }
                }
            }
            if ((geotoolsWriteParams = helper.getGeotoolsWriteParams()) != null && encodingParameters.containsKey(WRITENODATA_KEY)) {
                geotoolsWriteParams.parameter(GeoTiffFormat.WRITE_NODATA.getName().toString()).setValue(Boolean.parseBoolean((String)encodingParameters.get(WRITENODATA_KEY)));
            }
        }
    }

    @Override
    public String getFileExtension() {
        return "tiff";
    }

    public int getPriority() {
        return 0;
    }

    static {
        SUPPORTED_PARAMS.add(TILE_WIDTH_KEY);
        SUPPORTED_PARAMS.add(TILE_HEIGHT_KEY);
        SUPPORTED_PARAMS.add(COMPRESSION_KEY);
        SUPPORTED_PARAMS.add("quality");
        SUPPORTED_PARAMS.add(WRITENODATA_KEY);
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (String param : SUPPORTED_PARAMS) {
            sb.append(prefix).append(param);
            prefix = " / ";
        }
        SUPPORTED_PARAMS_LIST = sb.toString();
        LOGGER = Logging.getLogger(GeoTiffPPIO.class);
    }
}

