/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.lang.reflect.Method;
import org.geoserver.wps.ppio.LiteralPPIO;

public class EnumPPIO
extends LiteralPPIO {
    public EnumPPIO(Class<?> type) {
        super(type);
    }

    @Override
    public Object decode(String value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("Unable to look up enum value from null");
        }
        Method valueOf = this.getType().getMethod("valueOf", String.class);
        try {
            return valueOf.invoke(null, value);
        }
        catch (IllegalAccessException e) {
            return new LiteralPPIO(this.getType()).decode(value);
        }
        catch (Exception e) {
            try {
                return valueOf.invoke(null, value.toUpperCase());
            }
            catch (Exception e1) {
                try {
                    return valueOf.invoke(null, value.toLowerCase());
                }
                catch (Exception e2) {
                    throw e;
                }
            }
        }
    }

    @Override
    public String encode(Object value) throws Exception {
        return ((Enum)value).name();
    }
}

