/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.IOUtils;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.csv.CSVDataStoreFactory;
import org.geotools.data.csv.CSVFeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Text;

public class CSVPPIO
extends CDataPPIO {
    WPSResourceManager resourceManager;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wps.ppio.CSVPPIO");

    protected CSVPPIO(WPSResourceManager resourceManager) {
        super(SimpleFeatureCollection.class, SimpleFeatureCollection.class, "text/csv");
        this.resourceManager = resourceManager;
    }

    @Override
    public Object decode(String input) throws Exception {
        return this.decode(new ByteArrayInputStream(input.getBytes()));
    }

    @Override
    public String getFileExtension() {
        return "csv";
    }

    @Override
    public Object decode(Object input) throws Exception {
        Class<String> type = input.getClass();
        if (type.isAssignableFrom(String.class)) {
            return this.decode((String)input);
        }
        if (type.isAssignableFrom(Text.class)) {
            return this.decode(((Text)input).getValue());
        }
        return super.decode(input);
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        Resource tmp = this.resourceManager.getTemporaryResource(".csv");
        IOUtils.copy((InputStream)input, (OutputStream)tmp.out());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CSVDataStoreFactory.FILE_PARAM.key, tmp.file().getAbsoluteFile());
        params.put(CSVDataStoreFactory.STRATEGYP.key, "guess");
        CSVDataStore store = (CSVDataStore)DataStoreFinder.getDataStore(params);
        SimpleFeatureCollection collection = store.getFeatureSource().getFeatures();
        LOGGER.info("read in " + collection.size() + " features from CSV source");
        store.dispose();
        return collection;
    }

    @Override
    public void encode(Object value, OutputStream os) throws Exception {
        Resource tmp = this.resourceManager.getTemporaryResource(".csv");
        SimpleFeatureCollection collection = (SimpleFeatureCollection)value;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CSVDataStoreFactory.FILE_PARAM.key, tmp.file().getAbsoluteFile());
        params.put(CSVDataStoreFactory.STRATEGYP.key, "AttributesOnly");
        CSVDataStore store = (CSVDataStore)DataStoreFinder.getDataStore(params);
        store.createSchema((SimpleFeatureType)collection.getSchema());
        String name = store.getTypeName().getLocalPart();
        ContentFeatureSource featureSource = store.getFeatureSource(name, Transaction.AUTO_COMMIT);
        if (featureSource instanceof FeatureStore) {
            CSVFeatureStore csvFeatureStore = (CSVFeatureStore)featureSource;
            csvFeatureStore.addFeatures((FeatureCollection)collection);
        }
        store.dispose();
        IOUtils.copy((InputStream)tmp.in(), (OutputStream)os);
    }
}

