/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geoserver.wps.resource.GridCoverageReaderResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.parameter.Parameter;

public class ArcGridPPIO
extends CDataPPIO {
    private final WPSResourceManager resources;

    protected ArcGridPPIO(WPSResourceManager resources) {
        super(GridCoverage2D.class, GridCoverage2D.class, "application/arcgrid");
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(InputStream input) throws Exception {
        GridCoverage2D gridCoverage2D;
        block6: {
            File root = new File(System.getProperty("java.io.tmpdir", "."));
            File f = File.createTempFile("wps", "asc", root);
            GridCoverageReaderResource resource = null;
            try {
                FileUtils.copyInputStreamToFile((InputStream)input, (File)f);
                ArcGridFormat format = new ArcGridFormat();
                if (!format.accepts((Object)f)) {
                    throw new WPSException("Could not read " + this.getMimeType() + " coverage");
                }
                ArcGridReader reader = format.getReader((Object)f);
                resource = new GridCoverageReaderResource((AbstractGridCoverage2DReader)reader, f);
                gridCoverage2D = reader.read(null);
                if (resource != null) {
                    this.resources.addResource(resource);
                    break block6;
                }
                f.delete();
            }
            catch (Throwable throwable) {
                if (resource != null) {
                    this.resources.addResource(resource);
                } else {
                    f.delete();
                }
                throw throwable;
            }
        }
        return gridCoverage2D;
    }

    @Override
    public Object decode(String arcgrid) throws Exception {
        if (!((String)arcgrid).endsWith("\n")) {
            arcgrid = (String)arcgrid + "\n";
        }
        return this.decode(new ByteArrayInputStream(((String)arcgrid).getBytes()));
    }

    @Override
    public void encode(Object value, OutputStream os) throws IOException {
        Parameter forceSquareCells = new Parameter((ParameterDescriptor)ArcGridFormat.FORCE_CELLSIZE, (Object)Boolean.TRUE);
        new ArcGridFormat().getWriter((Object)os).write((GridCoverage)((GridCoverage2D)value), new GeneralParameterValue[]{forceSquareCells});
    }

    @Override
    public String getFileExtension() {
        return "asc";
    }
}

