/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.jts;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.process.factory.AnnotationDrivenProcessFactory;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.DescribeResults;
import org.geotools.process.function.ProcessFunctionFactory;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.FactoryIteratorProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringBeanProcessFactory
extends AnnotationDrivenProcessFactory
implements ApplicationContextAware,
ApplicationListener {
    Map<String, Class<?>> classMap;
    Map<String, String> beanMap;
    Class<?> markerInterface;
    ApplicationContext applicationContext;
    FactoryIteratorProvider iterator;

    public SpringBeanProcessFactory(String title, String namespace, Class<?> markerInterface) {
        super((InternationalString)new SimpleInternationalString(title), namespace);
        this.markerInterface = markerInterface;
        this.iterator = new FactoryIteratorProvider(){

            public <T> Iterator<T> iterator(Class<T> category) {
                if (ProcessFactory.class.isAssignableFrom(category)) {
                    return this.getFactoryIterator();
                }
                return null;
            }

            private <T> Iterator<T> getFactoryIterator() {
                return Collections.singletonList(SpringBeanProcessFactory.this).iterator();
            }
        };
        Processors.addProcessFactory((ProcessFactory)this);
        for (FunctionFactory ff : CommonFactoryFinder.getFunctionFactories(null)) {
            if (!(ff instanceof ProcessFunctionFactory)) continue;
            ProcessFunctionFactory pff = (ProcessFunctionFactory)ff;
            pff.clear();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        String[] beanNames = applicationContext.getBeanNamesForType(this.markerInterface, true, true);
        this.classMap = new HashMap();
        this.beanMap = new HashMap<String, String>();
        for (String beanName : beanNames) {
            Class c = applicationContext.getType(beanName);
            if (c == null) continue;
            String name = c.getSimpleName();
            if (name.endsWith("Process")) {
                name = name.substring(0, name.indexOf("Process"));
            }
            this.classMap.put(name, c);
            this.beanMap.put(name, beanName);
        }
    }

    protected DescribeProcess getProcessDescription(Name name) {
        Class<?> c = this.classMap.get(name.getLocalPart());
        if (c == null) {
            return null;
        }
        return c.getAnnotation(DescribeProcess.class);
    }

    protected Method method(String className) {
        Class<?> c = this.classMap.get(className);
        Method lastExecute = null;
        if (c != null) {
            for (Method m : c.getMethods()) {
                if (!m.getName().equals("execute")) continue;
                if (lastExecute != null) {
                    lastExecute = m;
                }
                if (m.getAnnotation(DescribeResult.class) == null && m.getAnnotation(DescribeResults.class) == null) continue;
                return m;
            }
        }
        return lastExecute;
    }

    public Set<Name> getNames() {
        LinkedHashSet<Name> result = new LinkedHashSet<Name>();
        ArrayList<String> names = new ArrayList<String>(this.classMap.keySet());
        Collections.sort(names);
        for (String name : names) {
            result.add((Name)new NameImpl(this.namespace, name));
        }
        return result;
    }

    protected Object createProcessBean(Name name) {
        String beanName = this.beanMap.get(name.getLocalPart());
        if (beanName == null) {
            return null;
        }
        return this.applicationContext.getBean(beanName);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            Processors.addProcessFactory((ProcessFactory)this);
        } else if (event instanceof ContextClosedEvent) {
            Processors.removeProcessFactory((ProcessFactory)this);
        }
    }
}

