/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wps10.ExecuteResponseType;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlObjectEncodingResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.geoserver.wps.ChainedProcessListener;
import org.geoserver.wps.ProcessDismissedException;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListener;
import org.geoserver.wps.UnknownExecutionIdException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.executor.ChainedProcessListenerNotifier;
import org.geoserver.wps.executor.ExecuteRequest;
import org.geoserver.wps.executor.ExecuteResponseBuilder;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.LazyInputMap;
import org.geoserver.wps.executor.MaxExecutionTimeListener;
import org.geoserver.wps.executor.ProcessListenerNotifier;
import org.geoserver.wps.executor.ProcessManager;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geoserver.wps.xml.WPSConfiguration;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.SubProgressListener;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class WPSExecutionManager
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = Logging.getLogger(WPSExecutionManager.class);
    private ExecutorService executors = Executors.newCachedThreadPool();
    ApplicationContext applicationContext;
    private WPSResourceManager resourceManager;
    private volatile List<ProcessManager> processManagers;
    private List<ProcessListener> listeners;
    private List<ChainedProcessListener> chainListeners;
    private int connectionTimeout;
    private boolean remoteInputDisabled;
    private ProcessStatusTracker statusTracker;
    private Map<String, ProcessListenerNotifier> localProcesses = new ConcurrentHashMap<String, ProcessListenerNotifier>();
    private Timer heartbeatTimer;
    private int heartbeatDelay;
    private GeoServer geoServer;

    public WPSExecutionManager(GeoServer geoServer, WPSResourceManager resourceManager, ProcessStatusTracker statusTracker) {
        this.resourceManager = resourceManager;
        this.statusTracker = statusTracker;
        this.geoServer = geoServer;
    }

    WPSResourceManager getResourceManager() {
        return this.resourceManager;
    }

    Map<String, Object> submitChained(ExecuteRequest request, ProgressListener listener) {
        Name processName = request.getProcessName();
        ProcessManager processManager = this.getProcessManager(processName);
        String executionId = this.resourceManager.getExecutionId(true);
        ChainedProcessListenerNotifier chainNotifier = new ChainedProcessListenerNotifier(executionId, processName.toString(), true, this.chainListeners);
        chainNotifier.fireStarted();
        LazyInputMap inputs = request.getProcessInputs(this);
        int inputsLongSteps = inputs.longStepCount();
        int longSteps = inputsLongSteps + 1;
        float longStepPercentage = 100.0f / (float)longSteps;
        float inputPercentage = (float)inputsLongSteps * longStepPercentage;
        float executionPercentage = 100.0f - inputPercentage;
        inputs.setListener((ProgressListener)new SubProgressListener(listener, inputPercentage));
        SubProgressListener executionListener = new SubProgressListener(listener, inputPercentage, executionPercentage);
        try {
            Map<String, Object> ret = processManager.submitChained(executionId, processName, inputs, (ProgressListener)executionListener);
            chainNotifier.fireCompleted();
            return ret;
        }
        catch (ProcessDismissedException e) {
            chainNotifier.fireDismissed();
            throw e;
        }
        catch (Exception e) {
            chainNotifier.fireFailed(e);
            throw e;
        }
    }

    public ExecuteResponseType submit(ExecuteRequest request, boolean synchronous) throws ProcessException {
        ExecuteResponseType response;
        Name processName = request.getProcessName();
        ProcessManager processManager = this.getProcessManager(processName);
        String executionId = this.resourceManager.getExecutionId(synchronous);
        LazyInputMap inputs = request.getProcessInputs(this);
        request.validateOutputs(inputs);
        ExecutionStatus status = new ExecutionStatus(processName, executionId, request.isAsynchronous());
        status.setRequest(request.getRequest());
        long maxExecutionTime = this.getMaxExecutionTime(synchronous);
        long maxTotalTime = this.getMaxTotalTime(synchronous);
        WPSInfo wps = (WPSInfo)this.geoServer.getService(WPSInfo.class);
        int resourceExpirationTimeout = wps.getResourceExpirationTimeout();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, resourceExpirationTimeout);
        status.setExpirationDate(calendar.getTime());
        status.setEstimatedCompletion(null);
        int nextPollTimeDelta = maxExecutionTime > 0L ? (int)maxExecutionTime / 2 : 10;
        calendar.setTime(new Date());
        calendar.add(13, nextPollTimeDelta);
        status.setNextPoll(new Date());
        Executor executor = new Executor(request, processManager, processName, inputs, synchronous, status, this.resourceManager, maxExecutionTime, maxTotalTime);
        if (synchronous) {
            response = executor.call();
        } else {
            LOGGER.log(Level.INFO, "Submitting new asynch process " + processName.getURI() + " with execution id " + executionId);
            try {
                this.resourceManager.storeRequestObject(request.getRequest(), executionId);
            }
            catch (IOException e) {
                throw new WPSException("Failed to store original WPS request, which will be needed to encode the output", e);
            }
            ExecuteResponseBuilder builder = new ExecuteResponseBuilder(request.getRequest(), this.applicationContext, status);
            response = builder.build();
            this.executors.submit(executor);
        }
        return response;
    }

    private long getMaxExecutionTime(boolean synchronous) {
        WPSInfo wps = (WPSInfo)this.geoServer.getService(WPSInfo.class);
        if (synchronous) {
            return wps.getMaxSynchronousExecutionTime() * 1000;
        }
        return wps.getMaxAsynchronousExecutionTime() * 1000;
    }

    private long getMaxTotalTime(boolean synchronous) {
        WPSInfo wps = (WPSInfo)this.geoServer.getService(WPSInfo.class);
        if (synchronous) {
            return wps.getMaxSynchronousTotalTime() * 1000;
        }
        return wps.getMaxAsynchronousTotalTime() * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ProcessManager> getProcessManagers() {
        if (this.processManagers == null) {
            WPSExecutionManager wPSExecutionManager = this;
            synchronized (wPSExecutionManager) {
                if (this.processManagers == null) {
                    this.processManagers = GeoServerExtensions.extensions(ProcessManager.class);
                }
            }
        }
        return this.processManagers;
    }

    ProcessManager getProcessManager(Name processName) {
        for (ProcessManager pm : this.getProcessManagers()) {
            if (!pm.canHandle(processName)) continue;
            return pm;
        }
        throw new WPSException("Could not find a ProcessManager able to run this process: " + processName);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isRemoteInputDisabled() {
        return this.remoteInputDisabled;
    }

    public void setRemoteInputDisabled(boolean remoteInputDisabled) {
        this.remoteInputDisabled = remoteInputDisabled;
    }

    public void setHeartbeatDelay(int heartbeatDelay) {
        if (heartbeatDelay != this.heartbeatDelay) {
            this.heartbeatDelay = heartbeatDelay;
            if (this.heartbeatTimer != null) {
                this.heartbeatTimer.cancel();
            }
            this.heartbeatTimer = new Timer();
            this.heartbeatTimer.schedule((TimerTask)new HeartbeatTask(), heartbeatDelay);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
        this.listeners = GeoServerExtensions.extensions(ProcessListener.class, (ApplicationContext)context);
        this.chainListeners = GeoServerExtensions.extensions(ChainedProcessListener.class, (ApplicationContext)context);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (this.executors == null) {
                this.executors = Executors.newCachedThreadPool();
            }
        } else if (event instanceof ContextClosedEvent) {
            this.executors.shutdownNow();
        }
    }

    public void cancel(String executionId) {
        ExecutionStatus status = this.statusTracker.getStatus(executionId);
        if (status == null) {
            throw new UnknownExecutionIdException(executionId);
        }
        if (status.getPhase() == ProcessState.RUNNING) {
            ProcessListenerNotifier notifier = this.localProcesses.get(executionId);
            if (notifier != null) {
                notifier.dismiss();
            } else {
                status.setPhase(ProcessState.DISMISSING);
                this.statusTracker.dismissing(new ProcessEvent(status, null, null));
            }
            status = this.statusTracker.getStatus(executionId);
            if (!status.getPhase().isExecutionCompleted()) {
                return;
            }
        }
        ProcessEvent event = new ProcessEvent(status, null);
        this.statusTracker.dismissed(event);
        this.resourceManager.dismissed(event);
    }

    private class HeartbeatTask
    extends TimerTask {
        private HeartbeatTask() {
        }

        @Override
        public void run() {
            for (String executionId : WPSExecutionManager.this.localProcesses.keySet()) {
                WPSExecutionManager.this.statusTracker.touch(executionId);
            }
        }
    }

    private final class Executor
    implements Callable<ExecuteResponseType> {
        private final ExecuteRequest request;
        private final ProcessManager processManager;
        private ExecutionStatus status;
        LazyInputMap inputs;
        private boolean synchronous;
        private ProcessListenerNotifier notifier;
        private ChainedProcessListenerNotifier chainNotifier;
        private ThreadLocalsTransfer transfer;
        private long maxExecutionTime;
        private long maxTotalTime;

        private Executor(ExecuteRequest request, ProcessManager processManager, Name processName, LazyInputMap inputs, boolean synchronous, ExecutionStatus status, WPSResourceManager resources, long maxExecutionTime, long maxTotalTime) {
            this.request = request;
            this.processManager = processManager;
            this.status = status;
            this.inputs = inputs;
            this.synchronous = synchronous;
            this.maxExecutionTime = maxExecutionTime;
            this.maxTotalTime = maxTotalTime;
            if (status.isAsynchronous()) {
                this.transfer = new ThreadLocalsTransfer();
            }
            this.notifier = new ProcessListenerNotifier(status, request, inputs, WPSExecutionManager.this.listeners);
            this.chainNotifier = new ChainedProcessListenerNotifier(status.getExecutionId(), processName.toString(), false, WPSExecutionManager.this.chainListeners);
            this.chainNotifier.fireStarted();
        }

        boolean hasComplexOutputs() {
            ProcessFactory pf = GeoServerProcessors.createProcessFactory(this.request.getProcessName(), false);
            Map resultInfo = pf.getResultInfo(this.request.getProcessName(), (Map)this.inputs);
            for (Parameter param : resultInfo.values()) {
                List<ProcessParameterIO> ppios = ProcessParameterIO.findAll(param, WPSExecutionManager.this.applicationContext);
                for (ProcessParameterIO ppio : ppios) {
                    if (!(ppio instanceof ComplexPPIO)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecuteResponseType call() {
            if (this.transfer != null) {
                try {
                    this.transfer.apply();
                    WPSExecutionManager.this.localProcesses.put(this.status.getExecutionId(), this.notifier);
                    ExecuteResponseType executeResponseType = this.execute();
                    return executeResponseType;
                }
                finally {
                    WPSExecutionManager.this.localProcesses.remove(this.status.getExecutionId());
                    try {
                        this.transfer.cleanup();
                    }
                    finally {
                        WPSExecutionManager.this.resourceManager.finished(this.status.getExecutionId());
                    }
                }
            }
            return this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private ExecuteResponseType execute() {
            ExecuteResponseType result;
            block65: {
                Object listener;
                float executionPercentage;
                float outputPercentage;
                float inputPercentage;
                Map<String, Object> outputs;
                block59: {
                    result = null;
                    outputs = null;
                    int inputsLongSteps = this.inputs.longStepCount();
                    int longSteps = inputsLongSteps + 1;
                    if (this.hasComplexOutputs()) {
                        ++longSteps;
                    }
                    float longStepPercentage = 98.0f / (float)longSteps;
                    boolean inputsBase = !this.inputs.isEmpty();
                    inputPercentage = (float)inputsBase + (float)inputsLongSteps * longStepPercentage;
                    outputPercentage = (this.hasComplexOutputs() ? longStepPercentage : 0.0f) + 1.0f;
                    executionPercentage = 100.0f - inputPercentage - outputPercentage;
                    listener = this.notifier.getProgressListener();
                    listener = new MaxExecutionTimeListener((ProgressListener)listener, this.maxExecutionTime, this.maxTotalTime);
                    this.inputs.setListener((ProgressListener)new SubProgressListener((ProgressListener)listener, 0.0f, inputPercentage));
                    SubProgressListener executionListener = new SubProgressListener((ProgressListener)listener, inputPercentage, executionPercentage);
                    this.notifier.checkDismissed();
                    this.processManager.submit(this.status.getExecutionId(), this.status.getProcessName(), this.inputs, (ProgressListener)executionListener, this.status.isAsynchronous());
                    this.notifier.checkDismissed();
                    outputs = this.processManager.getOutput(this.status.getExecutionId(), -1L);
                    if (this.status.getPhase() == ProcessState.RUNNING) {
                        this.notifier.fireProgress(inputPercentage + executionPercentage, "Execution completed, preparing to write response");
                    }
                    this.chainNotifier.fireCompleted();
                    if (this.status.getPhase() == ProcessState.RUNNING) {
                        this.notifier.fireProgress(inputPercentage + executionPercentage, "Writing outputs");
                    }
                    try {
                        ExecutionStatus completedStatus = new ExecutionStatus(this.status);
                        if (this.status.getPhase() == ProcessState.RUNNING) {
                            completedStatus.setPhase(ProcessState.SUCCEEDED);
                        } else {
                            completedStatus.setPhase(ProcessState.FAILED);
                        }
                        ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, completedStatus);
                        builder.setOutputs(outputs);
                        SubProgressListener outputListener = new SubProgressListener((ProgressListener)listener, inputPercentage + executionPercentage, outputPercentage);
                        result = builder.build((ProgressListener)outputListener);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Failed writing out the results", e);
                        if (this.status.getPhase() == ProcessState.DISMISSING) break block59;
                        this.notifier.fireFailed(e);
                    }
                }
                if (this.status.getPhase() != ProcessState.DISMISSING) {
                    if (this.synchronous) {
                        this.notifier.fireCompleted();
                    } else {
                        try {
                            Resource output = WPSExecutionManager.this.resourceManager.getStoredResponse(this.status.getExecutionId());
                            try {
                                if (this.status.getPhase() == ProcessState.RUNNING) {
                                    this.notifier.fireProgress(inputPercentage + executionPercentage + outputPercentage / 2.0f, "Writing out response");
                                }
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Request failed during output encoding", e);
                                this.status.setException(e);
                                ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, this.status);
                                builder.setOutputs(null);
                                result = builder.build();
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Failed to write out the stored WPS response for executionId " + this.status.getExecutionId(), e);
                            this.notifier.fireFailed(e);
                            throw new WPSException("Execution failed while writing the outputs", e);
                        }
                    }
                } else {
                    this.notifier.fireCompleted();
                }
                break block65;
                catch (ProcessDismissedException e) {
                    block61: {
                        block60: {
                            this.chainNotifier.fireDismissed();
                            if (this.status.getPhase() != ProcessState.RUNNING) break block60;
                            this.notifier.fireProgress(inputPercentage + executionPercentage, "Writing outputs");
                        }
                        try {
                            ExecutionStatus completedStatus = new ExecutionStatus(this.status);
                            if (this.status.getPhase() == ProcessState.RUNNING) {
                                completedStatus.setPhase(ProcessState.SUCCEEDED);
                            } else {
                                completedStatus.setPhase(ProcessState.FAILED);
                            }
                            ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, completedStatus);
                            builder.setOutputs(outputs);
                            SubProgressListener outputListener = new SubProgressListener((ProgressListener)listener, inputPercentage + executionPercentage, outputPercentage);
                            result = builder.build((ProgressListener)outputListener);
                        }
                        catch (Exception e2) {
                            LOGGER.log(Level.SEVERE, "Failed writing out the results", e2);
                            if (this.status.getPhase() == ProcessState.DISMISSING) break block61;
                            this.notifier.fireFailed(e2);
                        }
                    }
                    if (this.status.getPhase() != ProcessState.DISMISSING) {
                        if (this.synchronous) {
                            this.notifier.fireCompleted();
                        }
                        try {
                            Resource output = WPSExecutionManager.this.resourceManager.getStoredResponse(this.status.getExecutionId());
                            try {
                                if (this.status.getPhase() == ProcessState.RUNNING) {
                                    this.notifier.fireProgress(inputPercentage + executionPercentage + outputPercentage / 2.0f, "Writing out response");
                                }
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                            catch (Exception e3) {
                                LOGGER.log(Level.SEVERE, "Request failed during output encoding", e3);
                                this.status.setException(e3);
                                ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, this.status);
                                builder.setOutputs(null);
                                result = builder.build();
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                        }
                        catch (Exception e4) {
                            LOGGER.log(Level.SEVERE, "Failed to write out the stored WPS response for executionId " + this.status.getExecutionId(), e4);
                            this.notifier.fireFailed(e4);
                            throw new WPSException("Execution failed while writing the outputs", e4);
                        }
                    }
                    this.notifier.fireCompleted();
                }
                catch (Exception e2) {
                    block63: {
                        block62: {
                            if (this.status.getPhase() != ProcessState.DISMISSING) {
                                LOGGER.log(Level.SEVERE, "Process execution failed", e2);
                                this.notifier.fireFailed(e2);
                                this.chainNotifier.fireFailed(e2);
                            }
                            if (this.status.getPhase() != ProcessState.RUNNING) break block62;
                            this.notifier.fireProgress(inputPercentage + executionPercentage, "Writing outputs");
                            {
                                catch (Throwable throwable) {
                                    block64: {
                                        if (this.status.getPhase() == ProcessState.RUNNING) {
                                            this.notifier.fireProgress(inputPercentage + executionPercentage, "Writing outputs");
                                        }
                                        try {
                                            ExecutionStatus completedStatus = new ExecutionStatus(this.status);
                                            if (this.status.getPhase() == ProcessState.RUNNING) {
                                                completedStatus.setPhase(ProcessState.SUCCEEDED);
                                            } else {
                                                completedStatus.setPhase(ProcessState.FAILED);
                                            }
                                            ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, completedStatus);
                                            builder.setOutputs(outputs);
                                            SubProgressListener outputListener = new SubProgressListener((ProgressListener)listener, inputPercentage + executionPercentage, outputPercentage);
                                            result = builder.build((ProgressListener)outputListener);
                                        }
                                        catch (Exception e5) {
                                            LOGGER.log(Level.SEVERE, "Failed writing out the results", e5);
                                            if (this.status.getPhase() == ProcessState.DISMISSING) break block64;
                                            this.notifier.fireFailed(e5);
                                        }
                                    }
                                    if (this.status.getPhase() != ProcessState.DISMISSING) {
                                        if (this.synchronous) {
                                            this.notifier.fireCompleted();
                                        } else {
                                            try {
                                                Resource output = WPSExecutionManager.this.resourceManager.getStoredResponse(this.status.getExecutionId());
                                                try {
                                                    if (this.status.getPhase() == ProcessState.RUNNING) {
                                                        this.notifier.fireProgress(inputPercentage + executionPercentage + outputPercentage / 2.0f, "Writing out response");
                                                    }
                                                    this.writeOutResponse(result, output);
                                                    this.notifier.fireCompleted();
                                                }
                                                catch (Exception e6) {
                                                    LOGGER.log(Level.SEVERE, "Request failed during output encoding", e6);
                                                    this.status.setException(e6);
                                                    ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, this.status);
                                                    builder.setOutputs(null);
                                                    result = builder.build();
                                                    this.writeOutResponse(result, output);
                                                    this.notifier.fireCompleted();
                                                }
                                            }
                                            catch (Exception e7) {
                                                LOGGER.log(Level.SEVERE, "Failed to write out the stored WPS response for executionId " + this.status.getExecutionId(), e7);
                                                this.notifier.fireFailed(e7);
                                                throw new WPSException("Execution failed while writing the outputs", e7);
                                            }
                                        }
                                    } else {
                                        this.notifier.fireCompleted();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            ExecutionStatus completedStatus = new ExecutionStatus(this.status);
                            if (this.status.getPhase() == ProcessState.RUNNING) {
                                completedStatus.setPhase(ProcessState.SUCCEEDED);
                            } else {
                                completedStatus.setPhase(ProcessState.FAILED);
                            }
                            ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, completedStatus);
                            builder.setOutputs(outputs);
                            SubProgressListener outputListener = new SubProgressListener((ProgressListener)listener, inputPercentage + executionPercentage, outputPercentage);
                            result = builder.build((ProgressListener)outputListener);
                        }
                        catch (Exception e8) {
                            LOGGER.log(Level.SEVERE, "Failed writing out the results", e8);
                            if (this.status.getPhase() == ProcessState.DISMISSING) break block63;
                            this.notifier.fireFailed(e8);
                        }
                    }
                    if (this.status.getPhase() != ProcessState.DISMISSING) {
                        if (this.synchronous) {
                            this.notifier.fireCompleted();
                        }
                        try {
                            Resource output = WPSExecutionManager.this.resourceManager.getStoredResponse(this.status.getExecutionId());
                            try {
                                if (this.status.getPhase() == ProcessState.RUNNING) {
                                    this.notifier.fireProgress(inputPercentage + executionPercentage + outputPercentage / 2.0f, "Writing out response");
                                }
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                            catch (Exception e9) {
                                LOGGER.log(Level.SEVERE, "Request failed during output encoding", e9);
                                this.status.setException(e9);
                                ExecuteResponseBuilder builder = new ExecuteResponseBuilder(this.status.getRequest(), WPSExecutionManager.this.applicationContext, this.status);
                                builder.setOutputs(null);
                                result = builder.build();
                                this.writeOutResponse(result, output);
                                this.notifier.fireCompleted();
                            }
                        }
                        catch (Exception e10) {
                            LOGGER.log(Level.SEVERE, "Failed to write out the stored WPS response for executionId " + this.status.getExecutionId(), e10);
                            this.notifier.fireFailed(e10);
                            throw new WPSException("Execution failed while writing the outputs", e10);
                        }
                    }
                    this.notifier.fireCompleted();
                }
            }
            return result;
        }

        void writeOutResponse(ExecuteResponseType response, Resource output) throws IOException {
            try (OutputStream os = output.out();){
                XmlObjectEncodingResponse encoder = new XmlObjectEncodingResponse(ExecuteResponseType.class, "ExecuteResponse", WPSConfiguration.class);
                encoder.write((Object)response, os, null);
                LOGGER.log(Level.FINE, "Asynch process final response written to " + output.path());
            }
        }
    }
}

