/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.ByteArrayInputStream;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.LiteralDataType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.ppio.RawDataPPIO;
import org.geoserver.wps.process.ByteArrayRawData;
import org.geoserver.wps.process.StringRawData;
import org.geotools.api.util.ProgressListener;
import org.geotools.util.Base64;

class SimpleInputProvider
extends AbstractInputProvider {
    public SimpleInputProvider(InputType input, ProcessParameterIO ppio) {
        super(input, ppio);
    }

    @Override
    protected Object getValueInternal(ProgressListener listener) throws Exception {
        DataType data = this.input.getData();
        Object result = null;
        if (data.getLiteralData() != null) {
            LiteralDataType literal = data.getLiteralData();
            result = ((LiteralPPIO)this.ppio).decode(literal.getValue());
        } else if (data.getComplexData() != null) {
            ComplexDataType complex = data.getComplexData();
            if (this.ppio instanceof RawDataPPIO) {
                Object inputData = complex.getData().get(0);
                String encoding = complex.getEncoding();
                byte[] decoded = null;
                if (encoding != null) {
                    if ("base64".equals(encoding)) {
                        String input = inputData.toString();
                        decoded = Base64.decode((String)input);
                    } else {
                        throw new WPSException("Unsupported encoding " + encoding);
                    }
                }
                if (decoded != null) {
                    return new ByteArrayRawData(decoded, complex.getMimeType());
                }
                return new StringRawData(inputData.toString(), complex.getMimeType());
            }
            Object inputData = complex.getData().get(0);
            String encoding = complex.getEncoding();
            byte[] decoded = null;
            if (encoding != null) {
                if ("base64".equals(encoding)) {
                    String input = inputData.toString();
                    decoded = Base64.decode((String)input);
                } else {
                    throw new WPSException("Unsupported encoding " + encoding);
                }
            }
            result = decoded != null ? ((ComplexPPIO)this.ppio).decode(new ByteArrayInputStream(decoded)) : ((ComplexPPIO)this.ppio).decode(inputData);
        } else if (data.getBoundingBoxData() != null) {
            result = ((BoundingBoxPPIO)this.ppio).decode(data.getBoundingBoxData());
        }
        return result;
    }

    @Override
    public int longStepCount() {
        return 0;
    }
}

