/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.MethodType;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.executor.CancellingInputStream;
import org.geoserver.wps.executor.MaxSizeInputStream;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.ows.URLCheckers;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class RemoteRequestInputProvider
extends AbstractInputProvider {
    static final Logger LOGGER = Logging.getLogger(RemoteRequestInputProvider.class);
    private static LayeredConnectionSocketFactory socketFactory;
    private int timeout;
    private ComplexPPIO complexPPIO;
    private long maxSize;

    public RemoteRequestInputProvider(InputType input, ComplexPPIO ppio, int timeout, long maxSize) {
        super(input, ppio);
        this.timeout = timeout;
        this.complexPPIO = ppio;
        this.maxSize = maxSize;
        String location = input.getReference().getHref();
        URLCheckers.confirm((String)location);
    }

    @VisibleForTesting
    protected static void setSocketFactory(LayeredConnectionSocketFactory newSocketFactory) {
        socketFactory = newSocketFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Object getValueInternal(ProgressListener listener) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient buildHttpClient(String href) throws IOException {
        if (!RemoteRequestInputProvider.isHttpURL(href)) {
            return null;
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build();
        return HttpClients.custom().disableAutomaticRetries().disableRedirectHandling().setDefaultRequestConfig(config).setSSLSocketFactory(socketFactory).setUserAgent("GeoServer WPS RemoteInput").useSystemProperties().build();
    }

    private static boolean isHttpURL(String href) throws IOException {
        if (href == null) {
            return false;
        }
        String protocol = new URL(href).getProtocol();
        return "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
    }

    /*
     * Exception decompiling
     */
    private CloseableHttpResponse mainHttpRequest(CloseableHttpClient client, InputReferenceType ref, ProgressListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getBodyReferenceHref(InputReferenceType ref) {
        if (ref.getMethod() != MethodType.POST_LITERAL || ref.getBody() instanceof String) {
            return null;
        }
        if (ref.getBody() != null) {
            throw new WPSException("The request body should be contained in a CDATA section, otherwise it will get parsed as XML instead of being preserved as is", "NoApplicableCode", this.getInputId());
        }
        if (ref.getBodyReference() == null || ref.getBodyReference().getHref() == null) {
            throw new WPSException("A POST request should contain a non empty body", "NoApplicableCode", this.getInputId());
        }
        String bodyReferenceHref = ref.getBodyReference().getHref();
        URLCheckers.confirm((String)bodyReferenceHref);
        return bodyReferenceHref;
    }

    private static CloseableHttpResponse bodyHttpRequest(CloseableHttpClient client, String href) throws IOException {
        return RemoteRequestInputProvider.isHttpURL(href) ? client.execute(RequestBuilder.get((String)href).build()) : null;
    }

    private InputStream getInputStream(CloseableHttpResponse response, String href, ProgressListener listener) throws IOException {
        if (href == null) {
            return null;
        }
        URL url = new URL(href);
        Object is = response != null ? this.getResponseStream(response, href) : ("file".equalsIgnoreCase(url.getProtocol()) ? this.openFileURL(url) : this.openOtherURL(url));
        if (this.maxSize > 0L) {
            is = new MaxSizeInputStream((InputStream)is, this.getInputId(), this.maxSize);
        }
        return new CancellingInputStream((InputStream)is, listener);
    }

    private InputStream getResponseStream(CloseableHttpResponse response, String href) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IllegalStateException("Error getting remote resources from " + href + ", http error " + code + ": " + response.getStatusLine().getReasonPhrase());
        }
        try {
            Header length = response.getFirstHeader("Content-Length");
            if (this.maxSize > 0L && length != null && this.maxSize < Long.parseLong(length.getValue())) {
                throw new WPSException("Input " + this.getInputId() + " size " + length.getValue() + " exceeds maximum allowed size of " + this.maxSize + " according to HTTP Content-Length response header", "NoApplicableCode", this.getInputId());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, "Failed to parse content length to check input limits respect, moving on and checking data as it comes in", e);
        }
        return response.getEntity().getContent();
    }

    private InputStream openFileURL(URL url) throws IOException {
        File file = URLs.urlToFile((URL)url);
        if (this.maxSize > 0L && this.maxSize < file.length()) {
            throw new WPSException("Input " + this.getInputId() + " size " + file.length() + " exceeds maximum allowed size of " + this.maxSize, "NoApplicableCode", this.getInputId());
        }
        return FileUtils.openInputStream((File)file);
    }

    private InputStream openOtherURL(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(this.timeout);
        conn.setReadTimeout(this.timeout);
        return conn.getInputStream();
    }

    @Override
    public int longStepCount() {
        return 1;
    }
}

