/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum ProcessState {
    QUEUED(false, new ProcessState[0]),
    RUNNING(false, QUEUED),
    SUCCEEDED(true, RUNNING),
    DISMISSING(false, QUEUED, RUNNING),
    FAILED(true, QUEUED, RUNNING, DISMISSING);

    private boolean executionCompleted;
    private Set<ProcessState> predecessors;

    private ProcessState(boolean completed, ProcessState ... predecessors) {
        this.executionCompleted = completed;
        this.predecessors = new HashSet<ProcessState>(Arrays.asList(predecessors));
    }

    public boolean isExecutionCompleted() {
        return this.executionCompleted;
    }

    public boolean isValidSuccessor(ProcessState predecessor) {
        return predecessor == this || this.predecessors.contains((Object)predecessor);
    }
}

