/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Map;
import net.opengis.wps10.DocumentOutputDefinitionType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.MethodType;
import net.opengis.wps10.ResponseDocumentType;
import net.opengis.wps10.ResponseFormType;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.executor.CancellingFeatureCollectionBuilder;
import org.geoserver.wps.executor.ExecuteRequest;
import org.geoserver.wps.executor.LazyInputMap;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.kvp.ExecuteKvpRequestReader;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.util.ProgressListener;
import org.geotools.feature.FeatureCollection;
import org.springframework.context.ApplicationContext;

public class InternalWPSInputProvider
extends AbstractInputProvider {
    private WPSExecutionManager executor;
    private ExecuteRequest executeRequest;
    private int longSteps;

    public InternalWPSInputProvider(InputType input, ProcessParameterIO ppio, WPSExecutionManager executor, ApplicationContext context) throws Exception {
        super(input, ppio);
        this.executor = executor;
        ExecuteType request = null;
        InputReferenceType ref = input.getReference();
        if (ref.getMethod() == MethodType.POST_LITERAL) {
            request = (ExecuteType)ref.getBody();
        } else {
            ExecuteKvpRequestReader reader = (ExecuteKvpRequestReader)((Object)context.getBean("executeKvpRequestReader"));
            request = (ExecuteType)this.kvpParse(ref.getHref(), (KvpRequestReader)reader);
        }
        this.executeRequest = new ExecuteRequest(request);
        LazyInputMap inputs = this.executeRequest.getProcessInputs(executor);
        this.longSteps = inputs.longStepCount() + 1;
    }

    @Override
    protected Object getValueInternal(ProgressListener listener) throws Exception {
        Object obj;
        ResponseFormType responseForm;
        ResponseDocumentType responseDoc;
        Map<String, Object> results = this.executor.submitChained(this.executeRequest, listener);
        if (this.executeRequest.getRequest().getResponseForm() != null && (responseDoc = (responseForm = this.executeRequest.getRequest().getResponseForm()).getResponseDocument()) != null) {
            for (Object output : responseDoc.getOutput()) {
                DocumentOutputDefinitionType outputType = (DocumentOutputDefinitionType)output;
                String parameterName = outputType.getIdentifier().getValue();
                for (Map.Entry<String, Object> entry : results.entrySet()) {
                    Object value;
                    if (!entry.getKey().equalsIgnoreCase(parameterName) || (value = entry.getValue()) == null || !this.ppio.getType().isInstance(value)) continue;
                    return value;
                }
            }
        }
        if ((obj = results.values().iterator().next()) != null && !this.ppio.getType().isInstance(obj)) {
            throw new WPSException("The process output is incompatible with the input target type, was expecting " + this.ppio.getType().getName() + " and got " + obj.getClass().getName());
        }
        if (obj instanceof FeatureCollection) {
            obj = CancellingFeatureCollectionBuilder.wrap((FeatureCollection)obj, listener);
        }
        return obj;
    }

    @Override
    public int longStepCount() {
        return this.longSteps;
    }
}

