/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import net.opengis.wcs20.GetCoverageType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.MethodType;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs2_0.WebCoverageService20;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.util.ProgressListener;
import org.springframework.context.ApplicationContext;

public class InternalWCSInputProvider
extends AbstractInputProvider {
    private ApplicationContext context;

    public InternalWCSInputProvider(InputType input, ProcessParameterIO ppio, ApplicationContext context) {
        super(input, ppio);
        this.context = context;
    }

    @Override
    protected Object getValueInternal(ProgressListener listener) throws Exception {
        WebCoverageService111 wcs;
        Object getCoverage = null;
        InputReferenceType ref = this.input.getReference();
        if (ref.getMethod() == MethodType.POST_LITERAL) {
            getCoverage = ref.getBody();
        } else {
            String version = this.getVersion(ref.getHref());
            KvpRequestReader reader = "1.0.0".equals(version) || "1.0".equals(version) ? (KvpRequestReader)this.context.getBean("wcs100GetCoverageRequestReader") : ("2.0.1".equals(version) || "2.0.0".equals(version) ? (KvpRequestReader)this.context.getBean("wcs20getCoverageKvpParser") : (KvpRequestReader)this.context.getBean("wcs111GetCoverageRequestReader"));
            getCoverage = this.kvpParse(ref.getHref(), reader);
        }
        if (getCoverage instanceof net.opengis.wcs11.GetCoverageType) {
            wcs = (WebCoverageService111)this.context.getBean("wcs111ServiceTarget");
            return wcs.getCoverage((net.opengis.wcs11.GetCoverageType)getCoverage)[0];
        }
        if (getCoverage instanceof net.opengis.wcs10.GetCoverageType) {
            wcs = (WebCoverageService100)this.context.getBean("wcs100ServiceTarget");
            return wcs.getCoverage((net.opengis.wcs10.GetCoverageType)getCoverage)[0];
        }
        if (getCoverage instanceof GetCoverageType) {
            wcs = (WebCoverageService20)this.context.getBean("wcs20ServiceTarget");
            return wcs.getCoverage((GetCoverageType)getCoverage);
        }
        throw new WPSException("Unrecognized request type " + getCoverage);
    }

    @Override
    public int longStepCount() {
        return 0;
    }
}

