/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.ProcessSelector;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class UnsupportedParameterTypeProcessFilter
extends ProcessSelector
implements ApplicationContextAware {
    static final Logger LOGGER = Logging.getLogger(UnsupportedParameterTypeProcessFilter.class);
    private Set<Name> processBlacklist = new HashSet<Name>();

    @Override
    protected boolean allowProcess(Name processName) {
        return !this.processBlacklist.contains(processName);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.processBlacklist.clear();
        for (ProcessFactory pf : Processors.getProcessFactories()) {
            int count = 0;
            for (Name name : pf.getNames()) {
                try {
                    List<ProcessParameterIO> ppios;
                    for (Parameter p : pf.getParameterInfo(name).values()) {
                        ppios = ProcessParameterIO.findAll(p, context);
                        if (!ppios.isEmpty()) continue;
                        LOGGER.log(Level.CONFIG, "Blacklisting process " + name.getURI() + " as the input " + p.key + " of type " + p.type + " cannot be handled");
                        this.processBlacklist.add(name);
                    }
                    for (Parameter p : pf.getResultInfo(name, null).values()) {
                        ppios = ProcessParameterIO.findAll(p, context);
                        if (!ppios.isEmpty()) continue;
                        LOGGER.log(Level.CONFIG, "Blacklisting process " + name.getURI() + " as the output " + p.key + " of type " + p.type + " cannot be handled");
                        this.processBlacklist.add(name);
                    }
                }
                catch (Throwable t) {
                    this.processBlacklist.add(name);
                }
                if (this.processBlacklist.contains(name)) continue;
                ++count;
            }
            LOGGER.config("Found " + count + " bindable processes in " + pf.getTitle());
        }
    }
}

