/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.logging.Logger;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.ResponseDocumentType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.executor.ExecuteRequest;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class Execute {
    static final Logger LOGGER = Logging.getLogger(Execute.class);
    int connectionTimeout;
    WPSInfo wps;
    ApplicationContext context;
    WPSExecutionManager executionManager;

    public Execute(WPSExecutionManager executionManager, ApplicationContext context) {
        this.context = context;
        this.executionManager = executionManager;
    }

    public ExecuteResponseType run(ExecuteType execute) {
        ExecuteRequest request;
        ResponseDocumentType responseDocument = null;
        OutputDefinitionType rawDataOutput = null;
        if (execute.getResponseForm() != null) {
            responseDocument = execute.getResponseForm().getResponseDocument();
            rawDataOutput = execute.getResponseForm().getRawDataOutput();
        }
        if (responseDocument != null && rawDataOutput != null) {
            throw new WPSException("Invalid request, only one of the raw data output or the response document should be specified in the request");
        }
        ExecuteResponseType response = this.executionManager.submit(request, !(request = new ExecuteRequest(execute)).isAsynchronous());
        return response;
    }
}

