/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.hz;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.predicates.TruePredicate;
import java.util.ArrayList;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.LikeToRegexConverter;

public class FilterToCriteria
implements FilterVisitor {
    public Object visitNullFilter(Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return FalsePredicate.INSTANCE;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return TruePredicate.INSTANCE;
    }

    public Object visit(And filter, Object extraData) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Filter child : filter.getChildren()) {
            predicates.add((Predicate)child.accept((FilterVisitor)this, extraData));
        }
        return Predicates.and((Predicate[])predicates.toArray(new Predicate[predicates.size()]));
    }

    public Object visit(Id filter, Object extraData) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object id : filter.getIDs()) {
            ids.add(id.toString());
        }
        return Predicates.in((String)"executionId", (Comparable[])((Comparable[])ids.toArray(new String[ids.size()])));
    }

    public Object visit(Not filter, Object extraData) {
        return Predicates.not((Predicate)((Predicate)filter.getFilter().accept((FilterVisitor)this, extraData)));
    }

    public Object visit(Or filter, Object extraData) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Filter child : filter.getChildren()) {
            predicates.add((Predicate)child.accept((FilterVisitor)this, extraData));
        }
        return Predicates.or((Predicate[])predicates.toArray(new Predicate[predicates.size()]));
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        Comparable low = (Comparable)((Literal)filter.getLowerBoundary()).getValue();
        Comparable high = (Comparable)((Literal)filter.getLowerBoundary()).getValue();
        return Predicates.between((String)propertyName, (Comparable)low, (Comparable)high);
    }

    private String getPropertyName(Expression expression) {
        if (!(expression instanceof PropertyName)) {
            throw new IllegalArgumentException("Was expecting a property name, but found: " + expression);
        }
        String propertyName = ((PropertyName)expression).getPropertyName();
        if ("processName".equals(propertyName)) {
            propertyName = "simpleProcessName";
        }
        return propertyName;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return Predicates.equal((String)components.property, (Comparable)components.literal);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return Predicates.not((Predicate)Predicates.equal((String)components.property, (Comparable)components.literal));
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return components.inverted ? Predicates.lessEqual((String)components.property, (Comparable)components.literal) : Predicates.greaterThan((String)components.property, (Comparable)components.literal);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return components.inverted ? Predicates.lessThan((String)components.property, (Comparable)components.literal) : Predicates.greaterEqual((String)components.property, (Comparable)components.literal);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return components.inverted ? Predicates.greaterEqual((String)components.property, (Comparable)components.literal) : Predicates.lessThan((String)components.property, (Comparable)components.literal);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryComparisonOperator)filter);
        return components.inverted ? Predicates.greaterThan((String)components.property, (Comparable)components.literal) : Predicates.lessEqual((String)components.property, (Comparable)components.literal);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        String pattern = new LikeToRegexConverter(filter).getPattern();
        if (filter.isMatchingCase()) {
            return Predicates.like((String)propertyName, (String)pattern);
        }
        return Predicates.ilike((String)propertyName, (String)pattern);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        return Predicates.equal((String)propertyName, null);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        return Predicates.equal((String)propertyName, null);
    }

    public Object visit(BBOX filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Contains filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Disjoint filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Equals filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Intersects filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Within filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(After after, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryTemporalOperator)after);
        return components.inverted ? Predicates.lessEqual((String)components.property, (Comparable)components.literal) : Predicates.greaterThan((String)components.property, (Comparable)components.literal);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Before before, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryTemporalOperator)before);
        return components.inverted ? Predicates.greaterEqual((String)components.property, (Comparable)components.literal) : Predicates.lessThan((String)components.property, (Comparable)components.literal);
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(During during, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TEquals equals, Object extraData) {
        PropertyComparable components = new PropertyComparable((BinaryTemporalOperator)equals);
        return Predicates.equal((String)components.property, (Comparable)components.literal);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    private class PropertyComparable {
        String property;
        Comparable literal;
        boolean inverted;

        public PropertyComparable(BinaryComparisonOperator op) {
            if (op.getExpression1() instanceof PropertyName && op.getExpression2() instanceof Literal) {
                this.property = FilterToCriteria.this.getPropertyName(op.getExpression1());
                this.literal = (Comparable)((Literal)op.getExpression2()).getValue();
            } else if (op.getExpression2() instanceof PropertyName && op.getExpression1() instanceof Literal) {
                this.property = FilterToCriteria.this.getPropertyName(op.getExpression2());
                this.literal = (Comparable)((Literal)op.getExpression1()).getValue();
                this.inverted = true;
            } else {
                throw new IllegalArgumentException("Unsupported comparison, only comparison between an attribute and a static value are supported: " + op);
            }
        }

        public PropertyComparable(BinaryTemporalOperator op) {
            if (op.getExpression1() instanceof PropertyName && op.getExpression2() instanceof Literal) {
                this.property = ((PropertyName)op.getExpression1()).getPropertyName();
                this.literal = (Comparable)((Literal)op.getExpression2()).getValue();
            } else if (op.getExpression2() instanceof PropertyName && op.getExpression1() instanceof Literal) {
                this.property = ((PropertyName)op.getExpression2()).getPropertyName();
                this.literal = (Comparable)((Literal)op.getExpression1()).getValue();
                this.inverted = true;
            } else {
                throw new IllegalArgumentException("Unsupported comparison, only comparison between an attribute and a static value are supported: " + op);
            }
        }
    }
}

