/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.hz;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.query.impl.predicates.TruePredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.geoserver.wps.CompositeComparator;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.hz.FilterToCriteria;
import org.geoserver.wps.hz.HazelcastLoader;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.util.logging.Logging;

public class HazelcastStatusStore
implements ProcessStatusStore {
    static final Logger LOGGER = Logging.getLogger(HazelcastStatusStore.class);
    public static final String EXECUTION_STATUS_MAP = "wpsExecutionStatusMap";
    private static FilterCapabilities FILTER_CAPABILITIES = new FilterCapabilities();
    IMap<String, ExecutionStatus> statuses;

    public HazelcastStatusStore(HazelcastLoader loader) {
        this.statuses = loader.getInstance().getMap(EXECUTION_STATUS_MAP);
    }

    public void save(ExecutionStatus status) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Saving status " + status);
        }
        boolean succeded = false;
        while (!succeded) {
            ExecutionStatus oldStatus = (ExecutionStatus)this.statuses.get((Object)status.getExecutionId());
            if (oldStatus != null) {
                ProcessState previousPhase = oldStatus.getPhase();
                ProcessState currPhase = status.getPhase();
                if (!currPhase.isValidSuccessor(previousPhase)) {
                    throw new WPSException("Cannot switch process status from " + previousPhase + " to " + currPhase);
                }
                succeded = this.statuses.replace((Object)status.getExecutionId(), (Object)oldStatus, (Object)new ExecutionStatus(status));
                continue;
            }
            ExecutionStatus previous = (ExecutionStatus)this.statuses.put((Object)status.getExecutionId(), (Object)status);
            succeded = previous == null;
        }
    }

    public ExecutionStatus get(String executionId) {
        return (ExecutionStatus)this.statuses.get((Object)executionId);
    }

    public ExecutionStatus remove(String executionId) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Removing status for execution id: " + executionId);
        }
        return (ExecutionStatus)this.statuses.remove((Object)executionId);
    }

    public int remove(Filter filter) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Removing statuses matching: " + filter);
        }
        FilterPredicate filterPredicate = new FilterPredicate(filter);
        Predicate<String, ExecutionStatus> predicate = filterPredicate.predicate;
        Filter postFilter = filterPredicate.postFilter;
        Map results = this.statuses.executeOnEntries((EntryProcessor)new RemovingEntryProcessor(postFilter), predicate);
        int removedCount = results.size();
        return removedCount;
    }

    public List<ExecutionStatus> list(Query query) {
        int maxFeatures = query.getMaxFeatures();
        int startIndex = query.getStartIndex() == null ? 0 : query.getStartIndex();
        boolean needsSorting = query.getSortBy() != null && query.getSortBy().length > 0;
        FilterPredicate filterPredicate = new FilterPredicate(query.getFilter());
        PagingPredicateImpl predicate = filterPredicate.predicate;
        Filter postFilter = filterPredicate.postFilter;
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            FilteringEntryProcessor filterProcessor = new FilteringEntryProcessor(postFilter);
            Map entries = this.statuses.executeOnEntries((EntryProcessor)filterProcessor);
            ArrayList<ExecutionStatus> result = new ArrayList<ExecutionStatus>(entries.values());
            return this.postProcessResults(query, maxFeatures, startIndex, needsSorting, result);
        }
        if ((maxFeatures < Integer.MAX_VALUE || startIndex > 0) && postFilter != null) {
            Comparator pagingComparator = null;
            if (needsSorting) {
                pagingComparator = this.getComparator("value.", query.getSortBy());
            }
            predicate = pagingComparator != null ? new PagingPredicateImpl(predicate, pagingComparator, maxFeatures) : new PagingPredicateImpl(predicate, maxFeatures);
        }
        ArrayList<ExecutionStatus> result = new ArrayList<ExecutionStatus>();
        if (predicate instanceof PagingPredicate) {
            int position;
            PagingPredicate pp = (PagingPredicate)predicate;
            for (position = 0; position < startIndex - maxFeatures; position += maxFeatures) {
                pp.nextPage();
            }
            List page = new ArrayList(this.statuses.values((Predicate)pp));
            if (startIndex > position) {
                page = page.subList(startIndex - position, page.size());
            }
            result.addAll(page);
            if (result.size() < maxFeatures) {
                int missing = maxFeatures - result.size();
                pp.nextPage();
                ArrayList nextPage = new ArrayList(this.statuses.values((Predicate)pp));
                page = nextPage.subList(0, Math.min(missing, nextPage.size()));
                result.addAll(page);
            }
            return result;
        }
        result = new ArrayList(this.statuses.values((Predicate)predicate));
        return this.postProcessResults(query, maxFeatures, startIndex, needsSorting, result);
    }

    private List<ExecutionStatus> postProcessResults(Query query, int maxFeatures, int startIndex, boolean needsSorting, List<ExecutionStatus> result) {
        if (needsSorting) {
            Comparator comparator = this.getComparator("", query.getSortBy());
            Collections.sort(result, comparator);
        }
        if (startIndex > 0) {
            if (startIndex > result.size()) {
                result.clear();
            } else {
                result = new ArrayList<ExecutionStatus>(result.subList(startIndex, result.size()));
            }
        }
        if (maxFeatures < Integer.MAX_VALUE && maxFeatures < result.size()) {
            result = new ArrayList<ExecutionStatus>(result.subList(0, maxFeatures));
        }
        return result;
    }

    private <T> Comparator<T> getComparator(String prefix, SortBy[] sorts) {
        if (sorts == null || sorts.length == 0) {
            return null;
        }
        ArrayList<Object> comparators = new ArrayList<Object>();
        for (SortBy sort : sorts) {
            if (sort == SortBy.NATURAL_ORDER) {
                comparators.add(new BeanComparator(prefix + "creationTime"));
                continue;
            }
            if (sort == SortBy.REVERSE_ORDER) {
                comparators.add(Collections.reverseOrder(new BeanComparator(prefix + "creationTime")));
                continue;
            }
            String property = sort.getPropertyName().getPropertyName();
            Object comparator = new BeanComparator(prefix + property);
            if (sort.getSortOrder() == SortOrder.DESCENDING) {
                comparator = Collections.reverseOrder(comparator);
            }
            comparators.add(comparator);
        }
        if (comparators.size() > 1) {
            return new CompositeComparator(comparators);
        }
        return (Comparator)comparators.get(0);
    }

    public boolean supportsPredicate() {
        return true;
    }

    public boolean supportsPaging() {
        return true;
    }

    static {
        FILTER_CAPABILITIES.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        FILTER_CAPABILITIES.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        FILTER_CAPABILITIES.addType(0x400000L);
        FILTER_CAPABILITIES.addType(4096L);
        FILTER_CAPABILITIES.addType(2048L);
        FILTER_CAPABILITIES.addType(8192L);
        FILTER_CAPABILITIES.addType(After.class);
        FILTER_CAPABILITIES.addType(Before.class);
    }

    private static class FilteringEntryProcessor
    extends AbstractFilteringEntryProcessor {
        private static final long serialVersionUID = 8952526293041673921L;

        public FilteringEntryProcessor(Filter filter) {
            super(filter);
        }

        public Object process(Map.Entry<String, ExecutionStatus> entry) {
            if (this.getFilter().evaluate((Object)entry.getValue())) {
                return entry.getValue();
            }
            return null;
        }
    }

    private static class RemovingEntryProcessor
    extends AbstractFilteringEntryProcessor
    implements HazelcastInstanceAware {
        private static final long serialVersionUID = 4683730449542722338L;
        transient IMap<String, ExecutionStatus> map;

        public RemovingEntryProcessor(Filter filter) {
            super(filter);
        }

        public void setHazelcastInstance(HazelcastInstance instance) {
            this.map = instance.getMap(HazelcastStatusStore.EXECUTION_STATUS_MAP);
        }

        public Object process(Map.Entry<String, ExecutionStatus> entry) {
            if (this.getFilter().evaluate((Object)entry.getValue())) {
                this.map.remove((Object)entry.getKey());
                return 1;
            }
            return null;
        }
    }

    private static abstract class AbstractFilteringEntryProcessor
    implements EntryProcessor<String, ExecutionStatus, Object> {
        private static final long serialVersionUID = -912785821605141531L;
        transient Filter filter;
        String cql;

        public AbstractFilteringEntryProcessor(Filter filter) {
            this.filter = filter;
            this.cql = ECQL.toCQL((Filter)filter);
        }

        public EntryProcessor<String, ExecutionStatus, Object> getBackupProcessor() {
            return null;
        }

        protected Filter getFilter() {
            if (this.filter == null) {
                try {
                    this.filter = ECQL.toFilter((String)this.cql);
                }
                catch (CQLException e) {
                    throw new IllegalStateException("Invalid cql used to serialize filter: " + this.cql);
                }
            }
            return this.filter;
        }
    }

    private static class FilterPredicate {
        Filter postFilter;
        Predicate<String, ExecutionStatus> predicate;

        public FilterPredicate(Filter filter) {
            try {
                PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(FILTER_CAPABILITIES, null, null);
                filter.accept((FilterVisitor)splitter, null);
                this.postFilter = splitter.getFilterPost();
                Filter preFilter = splitter.getFilterPre();
                if (preFilter == Filter.INCLUDE) {
                    this.predicate = TruePredicate.truePredicate();
                } else {
                    FilterToCriteria transformer = new FilterToCriteria();
                    this.predicate = this.toPredicate(preFilter, transformer);
                }
            }
            catch (Exception e) {
                this.postFilter = filter;
                this.predicate = TruePredicate.truePredicate();
            }
        }

        private Predicate<String, ExecutionStatus> toPredicate(Filter preFilter, FilterToCriteria transformer) {
            return (Predicate)preFilter.accept((FilterVisitor)transformer, null);
        }
    }
}

