/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.ows.Ows11Util;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.web.ComplexInputPanel;
import org.geoserver.wps.web.EnumPanel;
import org.geoserver.wps.web.ExecuteRequest;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.OutputParameter;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.util.logging.Logging;

public class WPSRequestBuilderPanel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(WPSRequestBuilderPanel.class);
    ExecuteRequest execute;
    String description;
    private Component feedback;
    private WebMarkupContainer descriptionContainer;
    private WebMarkupContainer inputContainer;
    private WebMarkupContainer outputContainer;
    private ListView<InputParameterValues> inputView;
    private ListView<OutputParameter> outputView;
    String username;
    String password;
    boolean authenticate;

    public WPSRequestBuilderPanel(String id, ExecuteRequest executeRequest) {
        super(id);
        this.setOutputMarkupId(true);
        this.execute = executeRequest;
        Select2DropDownChoice processChoice = new Select2DropDownChoice("process", (IModel)new PropertyModel((Object)this.execute, "processName"), this.buildProcessList());
        this.add(new Component[]{processChoice});
        this.descriptionContainer = new WebMarkupContainer("descriptionContainer");
        this.descriptionContainer.setVisible(false);
        this.add(new Component[]{this.descriptionContainer});
        Label descriptionLabel = new Label("processDescription", (IModel)new PropertyModel((Object)this, "description"));
        this.descriptionContainer.add(new Component[]{descriptionLabel});
        this.inputContainer = new WebMarkupContainer("inputContainer");
        this.inputContainer.setVisible(false);
        this.add(new Component[]{this.inputContainer});
        this.inputView = new ListView<InputParameterValues>("inputs", (IModel)new PropertyModel((Object)this.execute, "inputs")){

            protected void populateItem(ListItem item) {
                InputParameterValues pv = (InputParameterValues)item.getModelObject();
                Parameter<?> p = pv.getParameter();
                item.add(new Component[]{new Label("param", (Serializable)((Object)WPSRequestBuilderPanel.this.buildParamSpec(p)))});
                item.add(new Component[]{new Label("paramDescription", (Serializable)((Object)p.description.toString(Locale.ENGLISH)))});
                PropertyModel property = new PropertyModel((Object)pv, "values[0].value");
                if (pv.isBoundingBox()) {
                    EnvelopePanel envelope = new EnvelopePanel("paramValue", (IModel)property);
                    envelope.setCRSFieldVisible(true);
                    item.add(new Component[]{envelope});
                } else if (pv.isCoordinateReferenceSystem()) {
                    CRSPanel crs = new CRSPanel("paramValue", (IModel)property);
                    item.add(new Component[]{crs});
                } else if (pv.isEnum()) {
                    EnumPanel panel = new EnumPanel("paramValue", pv.getParameter().type, (IModel<Enum>)property);
                    item.add(new Component[]{panel});
                } else if (pv.isComplex()) {
                    ComplexInputPanel input = new ComplexInputPanel("paramValue", pv, 0);
                    item.add(new Component[]{input});
                } else {
                    Fragment f = new Fragment("paramValue", "literal", (MarkupContainer)WPSRequestBuilderPanel.this);
                    TextField literal = new TextField("literalValue", (IModel)property);
                    literal.setRequired(p.minOccurs > 0);
                    literal.setLabel((IModel)new Model((Serializable)((Object)p.key)));
                    f.add(new Component[]{literal});
                    item.add(new Component[]{f});
                }
            }
        };
        this.inputView.setReuseItems(true);
        this.inputContainer.add(new Component[]{this.inputView});
        this.outputContainer = new WebMarkupContainer("outputContainer");
        this.outputContainer.setVisible(false);
        this.add(new Component[]{this.outputContainer});
        this.outputView = new ListView("outputs", (IModel)new PropertyModel((Object)this.execute, "outputs")){

            protected void populateItem(ListItem item) {
                OutputParameter pv = (OutputParameter)item.getModelObject();
                Parameter<?> p = pv.getParameter();
                item.add(new Component[]{new CheckBox("include", (IModel)new PropertyModel((Object)pv, "include"))});
                item.add(new Component[]{new Label("param", (Serializable)((Object)WPSRequestBuilderPanel.this.buildParamSpec(p)))});
                item.add(new Component[]{new Label("paramDescription", (Serializable)((Object)p.description.toString(Locale.ENGLISH)))});
                if (pv.isComplex()) {
                    DropDownChoice mime = new DropDownChoice("mime", (IModel)new PropertyModel((Object)pv, "mimeType"), pv.getSupportedMime());
                    item.add(new Component[]{mime});
                } else {
                    item.add(new Component[]{new Label("mime", (Serializable)((Object)"")).setVisible(false)});
                }
            }
        };
        this.outputView.setReuseItems(true);
        this.outputContainer.add(new Component[]{this.outputView});
        GeoServerAjaxFormLink describeLink = new GeoServerAjaxFormLink("describeProcess", (DropDownChoice)processChoice){
            final /* synthetic */ DropDownChoice val$processChoice;
            {
                this.val$processChoice = dropDownChoice;
                super(id);
            }

            protected void onClick(AjaxRequestTarget target, Form form) {
                this.val$processChoice.processInput();
                if (WPSRequestBuilderPanel.this.execute.processName != null) {
                    String xmlText = WPSRequestBuilderPanel.this.getDescribeXML(WPSRequestBuilderPanel.this.execute.processName);
                    TextField xml = (TextField)form.get("xml");
                    xml.setModelObject((Object)xmlText);
                    target.add(new Component[]{xml});
                    target.appendJavaScript((CharSequence)"executeWPS()");
                }
            }
        };
        this.descriptionContainer.add(new Component[]{describeLink});
        this.feedback = new FeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        this.add(new Component[]{this.feedback});
        processChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                WPSRequestBuilderPanel.this.initProcessView();
                target.add(new Component[]{WPSRequestBuilderPanel.this});
                WebPage page = WPSRequestBuilderPanel.this.getWebPage();
                if (page instanceof GeoServerBasePage) {
                    ((GeoServerBasePage)page).addFeedbackPanels(target);
                }
            }
        }});
        if (this.execute.processName != null) {
            this.initProcessView();
        }
        final WebMarkupContainer authenticationContainer = new WebMarkupContainer("authenticationContainer");
        authenticationContainer.setOutputMarkupId(true);
        this.add(new Component[]{authenticationContainer});
        final WebMarkupContainer userpwdContainer = new WebMarkupContainer("userpwdContainer");
        userpwdContainer.setOutputMarkupId(true);
        userpwdContainer.setVisible(false);
        authenticationContainer.add(new Component[]{userpwdContainer});
        TextField username = new TextField("username", (IModel)new PropertyModel((Object)this, "username"));
        userpwdContainer.add(new Component[]{username});
        PasswordTextField password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this, "password"));
        password.setRequired(false);
        userpwdContainer.add(new Component[]{password});
        CheckBox checkbox = new CheckBox("authenticate", (IModel)new PropertyModel((Object)this, "authenticate"));
        checkbox.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                userpwdContainer.setVisible(WPSRequestBuilderPanel.this.authenticate);
                target.add(new Component[]{authenticationContainer});
            }
        }});
        authenticationContainer.add(new Component[]{checkbox});
    }

    private void initProcessView() {
        Name name = Ows11Util.name((String)this.execute.processName);
        ProcessFactory pf = Processors.createProcessFactory((Name)name);
        if (pf == null) {
            this.error((Serializable)((Object)("No such process: " + this.execute.processName)));
            this.descriptionContainer.setVisible(false);
            this.inputContainer.setVisible(false);
            this.outputContainer.setVisible(false);
        } else {
            this.description = pf.getDescription(name).toString(Locale.ENGLISH);
            this.execute.inputs = this.buildInputParameters(pf, name);
            this.execute.outputs = this.buildOutputParameters(pf, name);
            this.inputView.removeAll();
            this.outputView.removeAll();
            this.descriptionContainer.setVisible(true);
            this.inputContainer.setVisible(true);
            this.outputContainer.setVisible(true);
        }
    }

    protected String getDescribeXML(String processId) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DescribeProcess service=\"WPS\" version=\"1.0.0\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <ows:Identifier>" + processId + "</ows:Identifier>\n</DescribeProcess>";
    }

    String buildParamSpec(Parameter<?> p) {
        Object spec = p.key;
        if (p.minOccurs > 0) {
            spec = (String)spec + "*";
        }
        spec = (String)spec + " - " + p.type.getSimpleName();
        if (p.minOccurs > 1 || p.maxOccurs != 1) {
            spec = (String)spec + "(" + p.minOccurs + "-";
            spec = p.maxOccurs == -1 ? (String)spec + "unbounded" : (String)spec + p.maxOccurs;
            spec = (String)spec + ")";
        }
        return spec;
    }

    protected List<InputParameterValues> buildInputParameters(ProcessFactory pf, Name processName) {
        Map params = pf.getParameterInfo(processName);
        ArrayList<InputParameterValues> result = new ArrayList<InputParameterValues>();
        for (String key : params.keySet()) {
            result.add(new InputParameterValues(processName, key));
        }
        return result;
    }

    protected List<OutputParameter> buildOutputParameters(ProcessFactory pf, Name processName) {
        Map params = pf.getResultInfo(processName, null);
        ArrayList<OutputParameter> result = new ArrayList<OutputParameter>();
        for (String key : params.keySet()) {
            result.add(new OutputParameter(processName, key));
        }
        return result;
    }

    List<String> buildProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessFactory pf : GeoServerProcessors.getProcessFactories()) {
            for (Name name : pf.getNames()) {
                result.add(name.getURI());
            }
        }
        Collections.sort(result);
        return result;
    }

    public Component getFeedbackPanel() {
        return this.feedback;
    }
}

