/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.web.FilteredProcessesProvider;
import org.geoserver.wps.web.ProcessLimitsPage;
import org.geoserver.wps.web.RolesAutoCompleteBehavior;
import org.geoserver.wps.web.RolesConverter;
import org.geoserver.wps.web.RolesRenderer;
import org.geoserver.wps.web.WPSAccessRulePage;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;

public class ProcessSelectionPage
extends AbstractSecurityPage {
    private String title;
    private GeoServerTablePanel<FilteredProcessesProvider.FilteredProcess> processSelector;
    private ProcessGroupInfo pfi;
    private List<String> availableRoles = new ArrayList<String>();

    public ProcessSelectionPage(final WPSAccessRulePage wpsAccessRulePage, final ProcessGroupInfo pfi) {
        this.pfi = pfi;
        Class factoryClass = pfi.getFactoryClass();
        ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)factoryClass, (boolean)false);
        if (pf == null) {
            throw new IllegalArgumentException("Failed to locate the process factory " + factoryClass);
        }
        this.title = pf.getTitle().toString(this.getLocale());
        Form form = new Form("form");
        this.add(new Component[]{form});
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        try {
            for (GeoServerRole r : roleService.getRoles()) {
                this.availableRoles.add(r.getAuthority());
            }
        }
        catch (IOException e1) {
            LOGGER.log(Level.FINER, e1.getMessage(), e1);
        }
        final FilteredProcessesProvider provider = new FilteredProcessesProvider(pfi, this.getLocale());
        final AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(false);
        settings.setShowListOnEmptyInput(true);
        settings.setShowListOnFocusGain(true);
        settings.setMaxHeightInPx(100);
        this.processSelector = new GeoServerTablePanel<FilteredProcessesProvider.FilteredProcess>("selectionTable", (GeoServerDataProvider)provider){

            protected Component getComponentForProperty(String id, final IModel<FilteredProcessesProvider.FilteredProcess> itemModel, GeoServerDataProvider.Property<FilteredProcessesProvider.FilteredProcess> property) {
                IModel model = property.getModel(itemModel);
                if (property.getName().equals("enabled")) {
                    Fragment fragment = new Fragment(id, "enabledFragment", (MarkupContainer)ProcessSelectionPage.this);
                    CheckBox enabled = new CheckBox("enabled", model);
                    enabled.setOutputMarkupId(true);
                    fragment.add(new Component[]{enabled});
                    return fragment;
                }
                if (property.getName().equals("title")) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property.getName().equals("description")) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property.getName().equals("roles")) {
                    Fragment fragment = new Fragment(id, "rolesFragment", (MarkupContainer)ProcessSelectionPage.this);
                    IModel pm = property.getModel(itemModel);
                    TextArea<Object> roles = new TextArea<Object>("roles", pm){

                        public <C> IConverter<C> getConverter(Class<C> type) {
                            return new RolesConverter(ProcessSelectionPage.this.availableRoles);
                        }
                    };
                    StringBuilder selectedRoles = new StringBuilder();
                    RolesRenderer roleRenderer = new RolesRenderer(selectedRoles);
                    RolesAutoCompleteBehavior b = new RolesAutoCompleteBehavior((IAutoCompleteRenderer<String>)roleRenderer, settings, selectedRoles, ProcessSelectionPage.this.availableRoles);
                    roles.setOutputMarkupId(true);
                    roles.add(new Behavior[]{b});
                    fragment.add(new Component[]{roles});
                    return fragment;
                }
                if (property.getName().equals("validated")) {
                    IModel hasValidatorsModel = model;
                    IModel & Serializable availableModel = (IModel & Serializable)() -> {
                        Boolean value = (Boolean)hasValidatorsModel.getObject();
                        if (Boolean.TRUE.equals(value)) {
                            return "*";
                        }
                        return "";
                    };
                    return new Label(id, (IModel)availableModel);
                }
                if (property.getName().equals("edit")) {
                    Fragment fragment = new Fragment(id, "linkFragment", (MarkupContainer)ProcessSelectionPage.this);
                    Link<Object> link = new Link<Object>("link"){

                        public void onClick() {
                            FilteredProcessesProvider.FilteredProcess fp = (FilteredProcessesProvider.FilteredProcess)itemModel.getObject();
                            this.setResponsePage((IRequestablePage)new ProcessLimitsPage((Page)ProcessSelectionPage.this, fp));
                        }
                    };
                    fragment.add(new Component[]{link});
                    return fragment;
                }
                return null;
            }
        };
        this.processSelector.setFilterable(false);
        this.processSelector.setPageable(false);
        this.processSelector.setOutputMarkupId(true);
        form.add(new Component[]{this.processSelector});
        SubmitLink apply = new SubmitLink("apply"){

            public void onSubmit() {
                pfi.getFilteredProcesses().clear();
                for (FilteredProcessesProvider.FilteredProcess process : provider.getItems()) {
                    if ((process.getRoles() == null || process.getRoles().isEmpty()) && process.getEnabled() && (process.getValidators() == null || process.getValidators().isEmpty())) continue;
                    ProcessInfo pai = process.toProcessInfo();
                    pfi.getFilteredProcesses().add(pai);
                }
                this.setResponsePage((IRequestablePage)wpsAccessRulePage);
            }
        };
        form.add(new Component[]{apply});
        Link<Object> cancel = new Link<Object>("cancel"){

            public void onClick() {
                this.setResponsePage((IRequestablePage)wpsAccessRulePage);
            }
        };
        form.add(new Component[]{cancel});
    }

    protected Collection<? extends Name> getFilteredProcesses() {
        ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)this.pfi.getFactoryClass(), (boolean)false);
        ArrayList disabled = new ArrayList(pf.getNames());
        for (FilteredProcessesProvider.FilteredProcess fp : this.processSelector.getSelection()) {
            disabled.remove(fp.getName());
        }
        return disabled;
    }

    protected String getDescription() {
        return new ParamResourceModel("description", (Component)this, new Object[]{this.title}).getString();
    }
}

