/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.wps.web.ExecuteRequest;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.RasterLayerConfiguration;
import org.geoserver.wps.web.ReferenceConfiguration;
import org.geoserver.wps.web.SubProcessBuilder;
import org.geoserver.wps.web.VectorLayerConfiguration;
import org.geoserver.wps.web.WPSExecuteTransformer;
import org.geoserver.wps.web.WPSRequestBuilderPanel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;

public class ComplexInputPanel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(WPSRequestBuilderPanel.class);
    private DropDownChoice typeChoice;
    PropertyModel<Object> valueModel;
    List<String> mimeTypes;
    GSModalWindow subprocesswindow;

    public ComplexInputPanel(String id, InputParameterValues pv, int valueIndex) {
        super(id);
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new PropertyModel((Object)pv, "values[" + valueIndex + "]"));
        this.valueModel = new PropertyModel((Object)this.getDefaultModel(), "value");
        this.mimeTypes = pv.getSupportedMime();
        List<InputParameterValues.ParameterType> ptypes = pv.getSupportedTypes();
        ptypes.remove((Object)InputParameterValues.ParameterType.LITERAL);
        this.typeChoice = new DropDownChoice("type", (IModel)new PropertyModel(this.getDefaultModelObject(), "type"), ptypes);
        this.add(new Component[]{this.typeChoice});
        this.subprocesswindow = new GSModalWindow("subprocessPopupWindow");
        this.subprocesswindow.setInitialWidth(700);
        this.subprocesswindow.setInitialHeight(500);
        this.add(new Component[]{this.subprocesswindow});
        this.updateEditor();
        this.typeChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                ComplexInputPanel.this.updateEditor();
                target.add(new Component[]{ComplexInputPanel.this});
            }
        }});
    }

    void updateEditor() {
        InputParameterValues.ParameterType pt;
        if (this.get("editor") != null) {
            this.remove("editor");
        }
        if ((pt = (InputParameterValues.ParameterType)((Object)this.typeChoice.getModelObject())) == InputParameterValues.ParameterType.TEXT) {
            if (!(this.valueModel.getObject() instanceof String)) {
                this.valueModel.setObject((Object)"");
            }
            Fragment f = new Fragment("editor", "text", (MarkupContainer)this);
            DropDownChoice mimeChoice = new DropDownChoice("mime", (IModel)new PropertyModel((Object)this.getDefaultModel(), "mime"), this.mimeTypes);
            f.add(new Component[]{mimeChoice});
            f.add(new Component[]{new TextArea("textarea", this.valueModel)});
            this.add(new Component[]{f});
        } else if (pt == InputParameterValues.ParameterType.VECTOR_LAYER) {
            if (!(this.valueModel.getObject() instanceof VectorLayerConfiguration)) {
                this.valueModel.setObject((Object)new VectorLayerConfiguration());
            }
            new PropertyModel((Object)this.getDefaultModel(), "mime").setObject((Object)"text/xml");
            Fragment f = new Fragment("editor", "vectorLayer", (MarkupContainer)this);
            Select2DropDownChoice layer = new Select2DropDownChoice("layer", (IModel)new PropertyModel(this.valueModel, "layerName"), this.getVectorLayerNames());
            f.add(new Component[]{layer});
            this.add(new Component[]{f});
        } else if (pt == InputParameterValues.ParameterType.RASTER_LAYER) {
            if (!(this.valueModel.getObject() instanceof RasterLayerConfiguration)) {
                this.valueModel.setObject((Object)new RasterLayerConfiguration());
            }
            Fragment f = new Fragment("editor", "rasterLayer", (MarkupContainer)this);
            Select2DropDownChoice layer = new Select2DropDownChoice("layer", (IModel)new PropertyModel(this.valueModel, "layerName"), this.getRasterLayerNames());
            f.add(new Component[]{layer});
            this.add(new Component[]{f});
            layer.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (DropDownChoice)layer){
                final /* synthetic */ DropDownChoice val$layer;
                {
                    this.val$layer = dropDownChoice;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    String name = this.val$layer.getDefaultModelObjectAsString();
                    LayerInfo li = GeoServerApplication.get().getCatalog().getLayerByName(name);
                    ReferencedEnvelope spatialDomain = li.getResource().getNativeBoundingBox();
                    ((RasterLayerConfiguration)ComplexInputPanel.this.valueModel.getObject()).setSpatialDomain(spatialDomain);
                }
            }});
        } else if (pt == InputParameterValues.ParameterType.REFERENCE) {
            if (!(this.valueModel.getObject() instanceof ReferenceConfiguration)) {
                this.valueModel.setObject((Object)new ReferenceConfiguration());
            }
            Fragment f = new Fragment("editor", "reference", (MarkupContainer)this);
            final DropDownChoice method = new DropDownChoice("method", (IModel)new PropertyModel(this.valueModel, "method"), Arrays.asList(ReferenceConfiguration.Method.GET, ReferenceConfiguration.Method.POST));
            f.add(new Component[]{method});
            DropDownChoice mimeChoice = new DropDownChoice("mime", (IModel)new PropertyModel(this.valueModel, "mime"), this.mimeTypes);
            f.add(new Component[]{mimeChoice});
            f.add(new Component[]{new TextField("url", (IModel)new PropertyModel(this.valueModel, "url")).setRequired(true)});
            final TextArea body = new TextArea("body", (IModel)new PropertyModel(this.valueModel, "body"));
            this.add(new Component[]{body});
            final WebMarkupContainer bodyContainer = new WebMarkupContainer("bodyContainer");
            f.add(new Component[]{bodyContainer});
            bodyContainer.setOutputMarkupId(true);
            bodyContainer.add(new Component[]{body});
            bodyContainer.setVisible(false);
            method.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

                protected void onUpdate(AjaxRequestTarget target) {
                    boolean post = method.getModelObject() == ReferenceConfiguration.Method.POST;
                    bodyContainer.setVisible(post);
                    body.setRequired(post);
                    target.add(new Component[]{ComplexInputPanel.this});
                }
            }});
            this.add(new Component[]{f});
        } else if (pt == InputParameterValues.ParameterType.SUBPROCESS) {
            if (!(this.valueModel.getObject() instanceof ExecuteRequest)) {
                this.valueModel.setObject((Object)new ExecuteRequest());
            }
            Fragment f = new Fragment("editor", "subprocess", (MarkupContainer)this);
            f.add(new Component[]{new AjaxLink<Object>("edit"){

                public void onClick(AjaxRequestTarget target) {
                    ComplexInputPanel.this.subprocesswindow.setDefaultModel(ComplexInputPanel.this.valueModel);
                    ComplexInputPanel.this.subprocesswindow.setContent((Component)new SubProcessBuilder((ExecuteRequest)ComplexInputPanel.this.subprocesswindow.getDefaultModelObject(), ComplexInputPanel.this.subprocesswindow));
                    ComplexInputPanel.this.subprocesswindow.show(target);
                }
            }});
            TextArea xml = new TextArea("xml");
            if (((ExecuteRequest)this.valueModel.getObject()).processName != null) {
                try {
                    xml.setModelObject((Object)this.getExecuteXML());
                }
                catch (Throwable t) {
                    xml.setModel((IModel)new Model((Serializable)((Object)"")));
                }
            } else {
                xml.setModel((IModel)new Model((Serializable)((Object)"")));
            }
            xml.setOutputMarkupId(true);
            f.add(new Component[]{xml});
            this.subprocesswindow.setWindowClosedCallback((GSModalWindow.WindowClosedCallback & Serializable)target -> {
                xml.setModelObject((Object)this.getExecuteXML());
                target.add(new Component[]{xml});
            });
            this.add(new Component[]{f});
        } else {
            this.error((Serializable)((Object)"Unsupported parameter type"));
        }
    }

    String getExecuteXML() {
        WPSExecuteTransformer tx = new WPSExecuteTransformer();
        tx.setEntityResolver(GeoServerApplication.get().getCatalog().getResourcePool().getEntityResolver());
        tx.setIndentation(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            tx.transform(this.valueModel.getObject(), out);
        }
        catch (TransformerException e) {
            LOGGER.log(Level.SEVERE, "Error generating xml request", e);
            this.error(e);
        }
        String executeXml = out.toString();
        return executeXml;
    }

    List<String> getVectorLayerNames() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<String> result = new ArrayList<String>();
        for (LayerInfo li : catalog.getLayers()) {
            if (!(li.getResource() instanceof FeatureTypeInfo)) continue;
            result.add(li.getResource().prefixedName());
        }
        return result;
    }

    List<String> getRasterLayerNames() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<String> result = new ArrayList<String>();
        for (LayerInfo li : catalog.getLayers()) {
            if (!(li.getResource() instanceof CoverageInfo)) continue;
            result.add(li.getResource().prefixedName());
        }
        return result;
    }
}

