/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestsPage;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.web.InputParameterValues;
import org.geoserver.wps.web.WPSRequestBuilder;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class WPSRequestBuilderTest
extends GeoServerWicketTestSupport {
    @Test
    public void testFirstProcessWorkflow() throws Exception {
        this.login();
        tester.startPage((Page)new WPSRequestBuilder());
        tester.assertComponent("form:requestBuilder:process", DropDownChoice.class);
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, String> desc = new HashMap<String, String>();
        WPSInfo wps = (WPSInfo)this.getGeoServer().getService(WPSInfo.class);
        for (ProcessGroupInfo p : wps.getProcessGroups()) {
            Class factoryClass = p.getFactoryClass();
            ProcessFactory pf = GeoServerProcessors.getProcessFactory((Class)factoryClass, (boolean)false);
            for (Object n : pf.getNames()) {
                names.add(n.toString());
                desc.put(n.toString(), pf.getDescription((Name)n).toString(Locale.ENGLISH));
            }
        }
        Collections.sort(names);
        String name = (String)names.get(0);
        String description = (String)desc.get(name);
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:requestBuilder:process");
        int index = -1;
        List choices = choice.getChoices();
        for (Object o : choices) {
            if (!o.equals(name)) continue;
            index = 0;
            break;
        }
        FormTester form = tester.newFormTester("form");
        form.select("requestBuilder:process", index);
        tester.executeAjaxEvent("form:requestBuilder:process", "change");
        tester.assertModelValue("form:requestBuilder:process", (Object)name);
        Label label = (Label)tester.getComponentFromLastRenderedPage("form:requestBuilder:descriptionContainer:processDescription");
        String observed = label.getDefaultModelObjectAsString();
        Assert.assertTrue((boolean)observed.contains(description));
        tester.assertComponent("form:requestBuilder:inputContainer:inputs:0:paramValue:editor:mime", DropDownChoice.class);
        tester.assertComponent("form:requestBuilder:inputContainer:inputs:0:paramValue:editor:textarea", TextArea.class);
        form = tester.newFormTester("form");
        form.select("requestBuilder:inputContainer:inputs:0:paramValue:editor:mime", 2);
        form.setValue("requestBuilder:inputContainer:inputs:0:paramValue:editor:textarea", "POLYGON((0 0, 0 10, 10 10, 10 0, 0 0))");
        form.submit();
        tester.clickLink("form:execute", true);
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"http://localhost/context/ows?strict=true", (Object)model.getRequestUrl());
        Assert.assertTrue((boolean)model.getRequestBody().contains("wps:Execute"));
        Assert.assertEquals(DemoRequestsPage.class, tester.getLastRenderedPage().getClass());
        Assert.assertEquals((long)2L, (long)tester.getLastRenderedPage().getPageParameters().getAllNamed().size());
        Assert.assertEquals((Object)"http://localhost/context/ows?strict=true", (Object)tester.getLastRenderedPage().getPageParameters().get("url").toString());
        Assert.assertTrue((boolean)tester.getLastRenderedPage().getPageParameters().get("xml").toString().contains("wps:Execute"));
    }

    @Test
    public void testNameRequest() throws Exception {
        this.login();
        tester.startPage((Page)new WPSRequestBuilder(new PageParameters().add("name", (Object)"JTS:area")));
        tester.assertComponent("form:requestBuilder:process", DropDownChoice.class);
        tester.assertModelValue("form:requestBuilder:process", (Object)"JTS:area");
        tester.assertComponent("form:requestBuilder:inputContainer:inputs:0:paramValue:editor:textarea", TextArea.class);
    }

    @Test
    public void testGetRequestXMLWithEntity() throws Exception {
        this.login();
        WPSRequestBuilder builder = (WPSRequestBuilder)tester.startPage((Page)new WPSRequestBuilder(new PageParameters().add("name", (Object)"JTS:area")));
        String resource = ((Object)((Object)this)).getClass().getResource("secret.txt").toExternalForm();
        ((InputParameterValues.ParameterValue)((InputParameterValues)builder.builder.execute.inputs.get((int)0)).values.get(0)).setValue((Serializable)((Object)("<?xml version=\"1.0\"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM \"" + resource + "\" >]><foo>&xxe;</foo>")));
        String executeXML = builder.getRequestXML();
        MatcherAssert.assertThat((Object)executeXML, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"HELLO WORLD")));
    }
}

