/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.data.store.panel.DirectoryParamPanel;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.WPSInfo;

public class WPSAdminPage
extends BaseServiceAdminPage<WPSInfo> {
    public WPSAdminPage() {
    }

    public WPSAdminPage(WPSInfo service) {
        super((ServiceInfo)service);
    }

    public WPSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    protected Class<WPSInfo> getServiceClass() {
        return WPSInfo.class;
    }

    protected String getServiceName() {
        return "WPS";
    }

    protected void build(IModel info, Form form) {
        TextField connectionTimeout = new TextField("connectionTimeout", Integer.class);
        connectionTimeout.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(-1)));
        form.add(new Component[]{connectionTimeout});
        TextField maxSynchProcesses = new TextField("maxSynchronousProcesses", Integer.class);
        maxSynchProcesses.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{maxSynchProcesses});
        TextField maxSynchExecutionTime = new TextField("maxSynchronousExecutionTime", Integer.class);
        maxSynchExecutionTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(-1)));
        form.add(new Component[]{maxSynchExecutionTime});
        TextField maxSynchTotalTime = new TextField("maxSynchronousTotalTime", Integer.class);
        maxSynchTotalTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(-1)));
        form.add(new Component[]{maxSynchTotalTime});
        TextField maxAsynchProcesses = new TextField("maxAsynchronousProcesses", Integer.class);
        maxAsynchProcesses.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{maxAsynchProcesses});
        TextField maxAsynchExecutionTime = new TextField("maxAsynchronousExecutionTime", Integer.class);
        maxAsynchExecutionTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(-1)));
        form.add(new Component[]{maxAsynchExecutionTime});
        TextField maxAsynchTotalTime = new TextField("maxAsynchronousTotalTime", Integer.class);
        maxAsynchTotalTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(-1)));
        form.add(new Component[]{maxAsynchTotalTime});
        TextField resourceExpirationTimeout = new TextField("resourceExpirationTimeout", Integer.class);
        resourceExpirationTimeout.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{resourceExpirationTimeout});
        DirectoryParamPanel chooser = new DirectoryParamPanel("storageDirectory", (IModel)new PropertyModel((Object)info, "storageDirectory"), (IModel)new ParamResourceModel("storageDirectory", (Component)this, new Object[0]), false, new IValidator[0]);
        form.add(new Component[]{chooser});
        form.add(new Component[]{new DirectoryParamPanel("externalOutputDirectory", (IModel)new PropertyModel((Object)info, "externalOutputDirectory"), (IModel)new ParamResourceModel("externalOutputDirectory", (Component)this, new Object[0]), false, new IValidator[0])});
        form.add((IFormValidator)new TotalTimeValidator((FormComponent<Integer>)maxSynchTotalTime, (FormComponent<Integer>)maxSynchExecutionTime));
        form.add((IFormValidator)new TotalTimeValidator((FormComponent<Integer>)maxAsynchTotalTime, (FormComponent<Integer>)maxAsynchExecutionTime));
    }

    protected void handleSubmit(WPSInfo info) {
        super.handleSubmit((ServiceInfo)info);
    }

    class TotalTimeValidator
    extends AbstractFormValidator {
        private static final long serialVersionUID = 1L;
        private FormComponent<Integer> totalTime;
        private FormComponent<Integer> executionTime;

        public TotalTimeValidator(FormComponent<Integer> totalTime, FormComponent<Integer> executionTime) {
            this.totalTime = totalTime;
            this.executionTime = executionTime;
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{this.totalTime, this.executionTime};
        }

        public void validate(Form<?> form) {
            if (this.executionTime.getConvertedInput() != null && this.totalTime.getConvertedInput() != null && (Integer)this.totalTime.getConvertedInput() != 0 && (Integer)this.totalTime.getConvertedInput() < (Integer)this.executionTime.getConvertedInput()) {
                form.error((Serializable)((Object)new ParamResourceModel("totalTimeError", (Component)WPSAdminPage.this.getPage(), new Object[0]).getString()));
            }
        }
    }
}

