/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;

public class RolesAutoCompleteBehavior
extends AutoCompleteBehavior<String> {
    private static final long serialVersionUID = -6743826046815447371L;
    private StringBuilder selectedRoles;
    private List<String> availableRoles;

    public RolesAutoCompleteBehavior(IAutoCompleteRenderer<String> renderer, AutoCompleteSettings settings, StringBuilder selectedRoles, List<String> availableRoles) {
        super(renderer, settings);
        this.selectedRoles = selectedRoles;
        this.availableRoles = availableRoles;
    }

    protected Iterator<String> getChoices(String input) {
        int lastCommaIndex = input.lastIndexOf(59);
        String realInput = "";
        if (lastCommaIndex == -1) {
            this.selectedRoles.setLength(0);
            realInput = input;
        } else {
            this.selectedRoles.setLength(0);
            this.selectedRoles.append(input.substring(0, lastCommaIndex) + ";");
            realInput = input.substring(lastCommaIndex + 1);
        }
        ArrayList<CallSite> completions = new ArrayList<CallSite>();
        for (String role : this.availableRoles) {
            List<String> sr;
            if (!realInput.isEmpty() && !role.startsWith(realInput.toUpperCase()) && !role.startsWith(realInput.toLowerCase()) || (sr = Arrays.asList(this.selectedRoles.toString().split(";"))).contains(role)) continue;
            completions.add((CallSite)((Object)(role + ";")));
        }
        Collections.sort(completions);
        return completions.iterator();
    }
}

