/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.DecimalTextField;
import org.geotools.util.NumberRange;

public class RangePanel
extends FormComponentPanel<NumberRange> {
    protected Double min;
    protected Double max;
    protected Label minLabel;
    protected Label maxLabel;
    protected DecimalTextField minInput;
    protected DecimalTextField maxInput;

    public RangePanel(String id) {
        super(id);
        this.initComponents();
    }

    public RangePanel(String id, NumberRange e) {
        this(id, (IModel<NumberRange>)new Model((Serializable)e));
    }

    public RangePanel(String id, IModel<NumberRange> model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        this.updateFields();
        Component[] componentArray = new Component[1];
        this.minLabel = new Label("minLabel", (IModel)new ResourceModel("min"));
        componentArray[0] = this.minLabel;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.maxLabel = new Label("maxLabel", (IModel)new ResourceModel("max"));
        componentArray2[0] = this.maxLabel;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.minInput = new DecimalTextField("min", (IModel)new PropertyModel((Object)this, "min"));
        componentArray3[0] = this.minInput;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.maxInput = new DecimalTextField("max", (IModel)new PropertyModel((Object)this, "max"));
        componentArray4[0] = this.maxInput;
        this.add(componentArray4);
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        NumberRange range = (NumberRange)this.getModelObject();
        if (range != null) {
            this.min = range.getMinimum();
            this.max = range.getMaximum();
        }
    }

    public RangePanel setReadOnly(boolean readOnly) {
        this.visitChildren(TextField.class, (component, visit) -> component.setEnabled(!readOnly));
        return this;
    }

    public void convertInput() {
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).processInput());
        if (this.min != null && this.max != null) {
            this.setConvertedInput(new NumberRange(Double.class, (Number)this.min, (Number)this.max));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).clearInput());
    }
}

