/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geoserver.wps.validator.WPSInputValidator;
import org.geoserver.wps.web.FilteredProcessesProvider;
import org.geoserver.wps.web.RangePanel;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.util.NumberRange;
import org.springframework.context.ApplicationContext;

public class ProcessLimitsPage
extends GeoServerSecuredPage {
    private static final Set<Class<?>> PRIMITIVE_NUMBERS = new ImmutableSet.Builder().add(Byte.TYPE).add(Character.TYPE).add(Double.TYPE).add(Float.TYPE).add(Integer.TYPE).add(Long.TYPE).add(Short.TYPE).build();
    private GeoServerTablePanel<InputLimit> table;
    private FilteredProcessesProvider.FilteredProcess process;

    public ProcessLimitsPage(Page returnPage, final FilteredProcessesProvider.FilteredProcess process) {
        this.setReturnPage(returnPage);
        this.process = process;
        Form form = new Form("form");
        this.add(new Component[]{form});
        final List<InputLimit> inputLimits = this.buildInputLimits(process);
        GeoServerDataProvider<InputLimit> inputLimitsProvider = new GeoServerDataProvider<InputLimit>(){

            protected List<GeoServerDataProvider.Property<InputLimit>> getProperties() {
                ArrayList<GeoServerDataProvider.Property<InputLimit>> result = new ArrayList<GeoServerDataProvider.Property<InputLimit>>();
                result.add((GeoServerDataProvider.Property<InputLimit>)new GeoServerDataProvider.BeanProperty("name", "name"));
                result.add((GeoServerDataProvider.Property<InputLimit>)new GeoServerDataProvider.PropertyPlaceholder("type"));
                result.add((GeoServerDataProvider.Property<InputLimit>)new GeoServerDataProvider.BeanProperty("editor", "validator"));
                return result;
            }

            protected List<InputLimit> getItems() {
                return inputLimits;
            }
        };
        this.table = new GeoServerTablePanel<InputLimit>("table", (GeoServerDataProvider)inputLimitsProvider){

            protected Component getComponentForProperty(String id, IModel<InputLimit> itemModel, GeoServerDataProvider.Property<InputLimit> property) {
                InputLimit limit = (InputLimit)itemModel.getObject();
                String propertyName = property.getName();
                if (propertyName.equals("type")) {
                    String type;
                    try {
                        String key = "type." + limit.getValidator().getClass().getName();
                        type = new ParamResourceModel(key, (Component)ProcessLimitsPage.this, new Object[0]).getString();
                    }
                    catch (Exception e) {
                        type = limit.validator.getClass().getSimpleName();
                    }
                    return new Label(id, (Serializable)((Object)type));
                }
                if (propertyName.equals("editor")) {
                    WPSInputValidator validator = limit.getValidator();
                    if (validator instanceof MaxSizeValidator) {
                        Fragment f = new Fragment(id, "textEditor", (MarkupContainer)ProcessLimitsPage.this);
                        PropertyModel maxSizeModel = new PropertyModel(itemModel, "validator.maxSizeMB");
                        TextField text = new TextField("text", (IModel)maxSizeModel, Integer.class);
                        f.add(new Component[]{text});
                        return f;
                    }
                    if (validator instanceof MultiplicityValidator) {
                        Fragment f = new Fragment(id, "textEditor", (MarkupContainer)ProcessLimitsPage.this);
                        PropertyModel maxMultiplicityModel = new PropertyModel(itemModel, "validator.maxInstances");
                        TextField text = new TextField("text", (IModel)maxMultiplicityModel, Integer.class);
                        f.add(new Component[]{text});
                        return f;
                    }
                    if (validator instanceof NumberRangeValidator) {
                        Fragment f = new Fragment(id, "rangeEditor", (MarkupContainer)ProcessLimitsPage.this);
                        RangePanel rangeEditor = new RangePanel("range", (IModel<NumberRange>)new PropertyModel(itemModel, "validator.range"));
                        f.add(new Component[]{rangeEditor});
                        return f;
                    }
                }
                return null;
            }
        };
        this.table.setOutputMarkupId(true);
        this.table.setFilterable(false);
        this.table.setPageable(false);
        this.table.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.table.setSortable(false);
        form.add(new Component[]{this.table});
        SubmitLink apply = new SubmitLink("apply"){

            public void onSubmit() {
                process.setValidators(ProcessLimitsPage.this.buildValidators(inputLimits));
                ProcessLimitsPage.this.doReturn();
            }
        };
        form.add(new Component[]{apply});
        Link<Object> cancel = new Link<Object>("cancel"){

            public void onClick() {
                ProcessLimitsPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    protected Multimap<String, WPSInputValidator> buildValidators(List<InputLimit> inputLimits) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (InputLimit inputLimit : inputLimits) {
            String name = inputLimit.getName();
            WPSInputValidator validator = inputLimit.getValidator();
            if (validator.isUnset()) continue;
            result.put((Object)name, (Object)validator);
        }
        return result;
    }

    private List<InputLimit> buildInputLimits(FilteredProcessesProvider.FilteredProcess process) {
        ApplicationContext applicationContext = GeoServerApplication.get().getApplicationContext();
        Multimap<String, WPSInputValidator> validators = process.getValidators();
        ProcessFactory pf = GeoServerProcessors.createProcessFactory((Name)process.getName(), (boolean)false);
        Map parameters = pf.getParameterInfo(process.getName());
        ArrayList<InputLimit> result = new ArrayList<InputLimit>();
        for (Parameter param : parameters.values()) {
            boolean isComplex;
            String name = param.getName();
            Collection paramValidators = validators != null ? validators.get((Object)name) : null;
            HashSet validatorTypes = new HashSet();
            if (paramValidators != null) {
                for (WPSInputValidator validator : paramValidators) {
                    validatorTypes.add(validator.getClass());
                    result.add(new InputLimit(name, validator.copy()));
                }
            }
            if (param.getMaxOccurs() > 1 && !validatorTypes.contains(MultiplicityValidator.class)) {
                int max = 0;
                if (param.getMaxOccurs() < Integer.MAX_VALUE) {
                    max = param.getMaxOccurs();
                }
                result.add(new InputLimit(name, (WPSInputValidator)new MultiplicityValidator(max)));
            }
            if (isComplex = ProcessParameterIO.isComplex((Parameter)param, (ApplicationContext)applicationContext)) {
                if (validatorTypes.contains(MaxSizeValidator.class)) continue;
                result.add(new InputLimit(name, (WPSInputValidator)new MaxSizeValidator(0)));
                continue;
            }
            if (!this.isNumeric(param) || validatorTypes.contains(NumberRangeValidator.class)) continue;
            result.add(new InputLimit(name, (WPSInputValidator)new NumberRangeValidator(null)));
        }
        return result;
    }

    private boolean isNumeric(Parameter param) {
        return Number.class.isAssignableFrom(param.getType()) || PRIMITIVE_NUMBERS.contains(param.getType());
    }

    protected String getTitle() {
        return new ParamResourceModel("title", (Component)this, new Object[]{this.process.getName().getURI()}).getString();
    }

    static final class InputLimit
    implements Serializable {
        private static final long serialVersionUID = -4763254264009929615L;
        String name;
        WPSInputValidator validator;

        public InputLimit(String name, WPSInputValidator validator) {
            this.name = name;
            this.validator = validator;
        }

        public String toString() {
            return "InputLimit [name=" + this.name + ", validator=" + this.validator + "]";
        }

        public String getName() {
            return this.name;
        }

        public WPSInputValidator getValidator() {
            return this.validator;
        }
    }
}

