/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.CoordinateReferenceSystemPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.ProcessFactory;

class InputParameterValues
implements Serializable {
    Name processName;
    String paramName;
    List<ParameterValue> values = new ArrayList<ParameterValue>();

    public InputParameterValues(Name processName, String paramName) {
        this.processName = processName;
        this.paramName = paramName;
        Parameter<?> p = this.getParameter();
        ParameterType type = this.guessBestType();
        String mime = this.getDefaultMime();
        for (int i = 0; i < Math.max(1, p.minOccurs); ++i) {
            this.values.add(new ParameterValue(type, mime, null));
        }
    }

    private ParameterType guessBestType() {
        if (!this.isComplex()) {
            return ParameterType.LITERAL;
        }
        if (FeatureCollection.class.isAssignableFrom(this.getParameter().type)) {
            return ParameterType.VECTOR_LAYER;
        }
        if (GridCoverage2D.class.isAssignableFrom(this.getParameter().type)) {
            return ParameterType.RASTER_LAYER;
        }
        return ParameterType.TEXT;
    }

    public List<ParameterType> getSupportedTypes() {
        if (!this.isComplex()) {
            return Collections.singletonList(ParameterType.LITERAL);
        }
        LinkedHashSet<ParameterType> result = new LinkedHashSet<ParameterType>();
        result.add(ParameterType.TEXT);
        result.add(ParameterType.REFERENCE);
        result.add(ParameterType.SUBPROCESS);
        for (ProcessParameterIO ppio : this.getProcessParameterIO()) {
            if (FeatureCollection.class.isAssignableFrom(ppio.getType())) {
                result.add(ParameterType.VECTOR_LAYER);
                continue;
            }
            if (!GridCoverage.class.isAssignableFrom(ppio.getType())) continue;
            result.add(ParameterType.RASTER_LAYER);
        }
        return new ArrayList<ParameterType>(result);
    }

    String getDefaultMime() {
        if (!this.isComplex()) {
            return null;
        }
        return ((ComplexPPIO)this.getProcessParameterIO().get(0)).getMimeType();
    }

    public List<String> getSupportedMime() {
        ArrayList<String> results = new ArrayList<String>();
        for (ProcessParameterIO ppio : this.getProcessParameterIO()) {
            ComplexPPIO cp = (ComplexPPIO)ppio;
            results.add(cp.getMimeType());
        }
        return results;
    }

    public boolean isEnum() {
        return Enum.class.isAssignableFrom(this.getParameter().type);
    }

    public boolean isComplex() {
        List<ProcessParameterIO> ppios = this.getProcessParameterIO();
        return !ppios.isEmpty() && ppios.get(0) instanceof ComplexPPIO;
    }

    public boolean isBoundingBox() {
        List<ProcessParameterIO> ppios = this.getProcessParameterIO();
        return !ppios.isEmpty() && ppios.get(0) instanceof BoundingBoxPPIO;
    }

    public boolean isCoordinateReferenceSystem() {
        List<ProcessParameterIO> ppios = this.getProcessParameterIO();
        return !ppios.isEmpty() && ppios.get(0) instanceof CoordinateReferenceSystemPPIO;
    }

    List<ProcessParameterIO> getProcessParameterIO() {
        return ProcessParameterIO.findAll(this.getParameter(), null);
    }

    ProcessFactory getProcessFactory() {
        return GeoServerProcessors.createProcessFactory((Name)this.processName, (boolean)false);
    }

    Parameter<?> getParameter() {
        return (Parameter)this.getProcessFactory().getParameterInfo(this.processName).get(this.paramName);
    }

    static class ParameterValue
    implements Serializable {
        ParameterType type;
        String mime;
        Serializable value;

        public ParameterValue(ParameterType type, String mime, Serializable value) {
            this.type = type;
            this.mime = mime;
            this.value = value;
        }

        public ParameterType getType() {
            return this.type;
        }

        public void setType(ParameterType type) {
            this.type = type;
        }

        public String getMime() {
            return this.mime;
        }

        public void setMime(String mime) {
            this.mime = mime;
        }

        public Serializable getValue() {
            return this.value;
        }

        public void setValue(Serializable value) {
            this.value = value;
        }
    }

    public static enum ParameterType {
        LITERAL,
        TEXT,
        VECTOR_LAYER,
        RASTER_LAYER,
        REFERENCE,
        SUBPROCESS;

    }
}

