/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wps.MonkeyProcess;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.web.ProcessStatusPage;
import org.geoserver.wps.web.WPSPagesTestSupport;
import org.geotools.api.data.Query;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ProcessStatusPageTest
extends WPSPagesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wps", "http://www.opengis.net/wps/1.0.0");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("feature", "http://geoserver.sf.net");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void test() throws Exception {
        this.login();
        String request = "wps?service=WPS&version=1.0.0&request=Execute&Identifier=gs:Monkey&storeExecuteResponse=true&DataInputs=" + URLEncoder.encode("id=x2", "ASCII");
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathExists((String)"//wps:ProcessAccepted", (Document)dom);
        MonkeyProcess.progress((String)"x2", (float)10.0f, (boolean)true);
        tester.startPage((Page)new ProcessStatusPage());
        tester.assertLabel("table:listContainer:items:1:itemProperties:3:component", "gs:Monkey");
        tester.assertLabel("table:listContainer:items:1:itemProperties:5:component", "RUNNING");
        List<ExecutionStatus> executions = this.getItems();
        Assert.assertEquals((long)1L, (long)executions.size());
        ExecutionStatus status = executions.get(0);
        SimpleDateFormat df = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss.SSS 'GMT'", tester.getSession().getLocale());
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        tester.assertLabel("table:listContainer:items:1:itemProperties:7:component", df.format(status.getExpirationDate()));
        tester.assertLabel("table:listContainer:items:1:itemProperties:8:component", df.format(status.getEstimatedCompletion()));
        tester.assertLabel("table:listContainer:items:1:itemProperties:9:component", df.format(status.getNextPoll()));
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        table.selectIndex(0);
        tester.getComponentFromLastRenderedPage("headerPanel:dismissSelected").setEnabled(true);
        tester.clickLink("headerPanel:dismissSelected");
        tester.clickLink("dialog:dialog:modal:overlay:dialog:content:content:form:submit", true);
        tester.getComponentFromLastRenderedPage("dialog:dialog:modal").getBehaviors().forEach(b -> {
            String name = b.getClass().getSimpleName();
            if (name.contains("WindowClosedBehavior")) {
                tester.executeBehavior((AbstractAjaxBehavior)b);
            }
        });
        tester.assertComponentOnAjaxResponse("table");
        tester.assertLabel("table:listContainer:items:2:itemProperties:3:component", "gs:Monkey");
        tester.assertLabel("table:listContainer:items:2:itemProperties:5:component", "DISMISSING");
        MonkeyProcess.exit((String)"x2", null, (boolean)true);
    }

    protected List<ExecutionStatus> getItems() {
        ProcessStatusTracker tracker = (ProcessStatusTracker)GeoServerApplication.get().getBeanOfType(ProcessStatusTracker.class);
        return tracker.getStore().list(Query.ALL);
    }

    static {
        Processors.addProcessFactory((ProcessFactory)MonkeyProcess.getFactory());
    }
}

