/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.web;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequestsPage;
import org.geoserver.web.demo.PlainCodePage;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.wps.web.ExecuteRequest;
import org.geoserver.wps.web.WPSExecuteTransformer;
import org.geoserver.wps.web.WPSRequestBuilderPanel;

public class WPSRequestBuilder
extends GeoServerBasePage {
    public static final String PARAM_NAME = "name";
    WPSRequestBuilderPanel builder;
    TextField<String> xml;

    public WPSRequestBuilder(PageParameters parameters) {
        this(parameters.get(PARAM_NAME).toOptionalString());
    }

    public WPSRequestBuilder() {
        this((String)null);
    }

    public WPSRequestBuilder(String procName) {
        Form form = new Form("form");
        this.add(new Component[]{form});
        Model model = new Model((Serializable)new WPSRequestModel());
        form.setDefaultModel((IModel)model);
        this.xml = new TextField("xml", (IModel)new PropertyModel((Object)model, "xml"));
        this.xml.setOutputMarkupId(true);
        form.add(new Component[]{this.xml});
        ExecuteRequest execRequest = new ExecuteRequest();
        if (procName != null) {
            execRequest.processName = procName;
        }
        this.builder = new WPSRequestBuilderPanel("requestBuilder", execRequest);
        form.add(new Component[]{this.builder});
        final GSModalWindow xmlWindow = new GSModalWindow("xmlWindow");
        this.add(new Component[]{xmlWindow});
        form.add(new Component[]{new AjaxSubmitLink("setXml"){

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    String xmlText = WPSRequestBuilder.this.getRequestXML();
                    WPSRequestBuilder.this.xml.setModelObject((Object)xmlText);
                    target.add(new Component[]{WPSRequestBuilder.this.xml});
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    WPSRequestBuilder.this.addFeedbackPanels(target);
                }
                target.appendJavaScript((CharSequence)"executeWPS()");
            }

            protected void onError(AjaxRequestTarget target) {
                WPSRequestBuilder.this.addFeedbackPanels(target);
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("execute"){

            protected void onSubmit(AjaxRequestTarget target) {
                HttpServletRequest http = GeoServerApplication.get().servletRequest();
                String url = ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)http), (String)"ows", Collections.singletonMap("strict", "true"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                String xml = WPSRequestBuilder.this.getRequestXML();
                PageParameters parameters = new PageParameters();
                parameters.add("url", (Object)url);
                parameters.add("xml", (Object)xml);
                this.getRequestCycle().setResponsePage(DemoRequestsPage.class, parameters);
            }

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{WPSRequestBuilder.this.builder.getFeedbackPanel()});
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("executeXML"){

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    xmlWindow.setContent((Component)new PlainCodePage(xmlWindow.getContentId(), WPSRequestBuilder.this.getRequestXML()));
                    xmlWindow.show(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    WPSRequestBuilder.this.addFeedbackPanels(target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                WPSRequestBuilder.this.addFeedbackPanels(target);
            }
        }});
    }

    String getRequestXML() {
        WPSExecuteTransformer tx = new WPSExecuteTransformer(this.getCatalog());
        tx.setEntityResolver(this.getCatalog().getResourcePool().getEntityResolver());
        tx.setIndentation(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            tx.transform(this.builder.execute, out);
        }
        catch (TransformerException e) {
            LOGGER.log(Level.SEVERE, "Error generating xml request", e);
            this.error(e);
        }
        return out.toString();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)DemoRequestsPage.demoRequestsJavascript, null));
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)"#xml {display: none;}", (String)"wpsRequestBuilderCSS"));
    }

    public class WPSRequestModel
    implements Serializable {
        public String xml;

        public String getXml() {
            return this.xml;
        }

        public void setXml(String xml) {
            this.xml = xml;
        }
    }
}

